/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.sarasvati.loader;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.sarasvati.loader.WfProfileDescriptor;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class ProfileToSarasvatiConverter {
    private ServiceLocator<ISLookUpService> lookupLocator;
    private Resource xslt;
    private static final Log log = LogFactory.getLog(ProfileToSarasvatiConverter.class);

    public WfProfileDescriptor getSarasvatiWorkflow(String id) throws DocumentException {
        String s = this.getProfile(id);
        Document doc = new SAXReader().read((Reader)new StringReader(s));
        WfProfileDescriptor desc = new WfProfileDescriptor();
        desc.setName(doc.valueOf("//WORKFLOW_NAME"));
        desc.setType(doc.valueOf("//WORKFLOW_TYPE"));
        desc.setPriority(NumberUtils.toInt((String)"//WORKFLOW_PRIORITY", (int)50));
        desc.setWorkflowXml(new ApplyXslt(this.xslt).evaluate((Object)s));
        desc.setReady(doc.selectNodes("//PARAM[@required='true' and string-length(normalize-space(.)) = 0]").isEmpty());
        return desc;
    }

    public String getProfile(String id) {
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(id);
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error finding profile: " + id), (Throwable)e);
            return null;
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public Resource getXslt() {
        return this.xslt;
    }

    @Required
    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }
}

