/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.sarasvati.loader;

import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.mem.MemEngine;
import com.googlecode.sarasvati.mem.MemGraph;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class GraphLoader {
    private MemEngine engine;
    private static final Log log = LogFactory.getLog(GraphLoader.class);

    public Graph loadGraph(String xml) throws Exception {
        File tmpFile = File.createTempFile("wftfs", null);
        try {
            IOUtils.copy((Reader)new StringReader(xml), (OutputStream)new FileOutputStream(tmpFile));
            SAXReader reader = new SAXReader();
            Document doc = reader.read(tmpFile);
            String graphName = doc.valueOf("/process-definition/@name");
            this.getEngine().getLoader().load(tmpFile);
            MemGraph graph = this.getEngine().getRepository().getLatestGraph(graphName);
            if (graph == null) {
                throw new IllegalArgumentException("graph called " + graphName + " doesn't exist");
            }
            MemGraph memGraph = graph;
            return memGraph;
        }
        catch (DocumentException e) {
            log.error((Object)("Error parsing xml: " + xml), (Throwable)e);
            throw e;
        }
        finally {
            tmpFile.delete();
        }
    }

    public MemEngine getEngine() {
        return this.engine;
    }

    @Required
    public void setEngine(MemEngine engine) {
        this.engine = engine;
    }
}

