/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.transform;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.HashMap;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ApplyXsltJobNode
extends SimpleJobNode {
    private String inputEprParam;
    private String outputEprParam;
    private String xsltClasspath;
    private XSLTMappedResultSetFactory xsltMappedResultSetFactory;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String inputEpr = token.getEnv().getAttribute(this.inputEprParam);
        if (inputEpr == null || inputEpr.isEmpty()) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        HashMap<String, String> xsltParams = new HashMap<String, String>();
        for (String name : token.getFullEnv().getAttributeNames()) {
            xsltParams.put(name, token.getFullEnv().getAttribute(name));
        }
        for (String name : token.getEnv().getAttributeNames()) {
            xsltParams.put(name, token.getEnv().getAttribute(name));
        }
        xsltParams.putAll(this.parseJsonParameters(token));
        W3CEndpointReference epr = this.xsltMappedResultSetFactory.createMappedResultSet(new EPRUtils().getEpr(inputEpr), (Resource)new ClassPathResource(this.xsltClasspath), xsltParams);
        token.getEnv().setAttribute(this.outputEprParam, epr.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getXsltClasspath() {
        return this.xsltClasspath;
    }

    public void setXsltClasspath(String xsltClasspath) {
        this.xsltClasspath = xsltClasspath;
    }

    public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
        return this.xsltMappedResultSetFactory;
    }

    @Required
    public void setXsltMappedResultSetFactory(XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
        this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
    }
}

