/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.repobye;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class DeleteMetaWfJobNode
extends SimpleJobNode {
    private String metaWfId;
    @Resource(name="registryLocator")
    private ServiceLocator<ISRegistryService> registryLocator;
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private static final Log log = LogFactory.getLog(DeleteMetaWfJobNode.class);

    @Override
    protected String execute(NodeToken token) throws Exception {
        String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(this.metaWfId);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        String dsId = doc.valueOf("//DATAPROVIDER/@id");
        String dsName = doc.valueOf("//DATAPROVIDER/text()");
        String ifaceId = doc.valueOf("//DATAPROVIDER/@interface");
        String destroyWfId = doc.valueOf("//CONFIGURATION/@destroyWorkflow");
        log.info((Object)("Removing a MetaWf of dataprovider: " + dsId));
        token.getEnv().setAttribute("dataprovider:id", dsId);
        token.getEnv().setAttribute("dataprovider:name", dsName);
        token.getEnv().setAttribute("dataprovider:interface", ifaceId);
        for (Object o : doc.selectNodes("//WORKFLOW")) {
            String wfId = ((Node)o).valueOf("@id");
            try {
                ((ISRegistryService)this.registryLocator.getService()).deleteProfile(wfId);
                log.info((Object)(" - Deleted Workflow: " + wfId));
            }
            catch (Exception e) {
                log.error((Object)(" - (ERR) Error deleting profile " + wfId));
            }
        }
        ((ISRegistryService)this.registryLocator.getService()).deleteProfile(this.metaWfId);
        log.info((Object)(" - Deleted MetaWorkflow: " + this.metaWfId));
        ((ISRegistryService)this.registryLocator.getService()).deleteProfile(destroyWfId);
        log.info((Object)(" - Deleted destroy workflow: " + destroyWfId));
        this.verifyDatasource(dsId, ifaceId);
        return Arc.DEFAULT_ARC;
    }

    private void verifyDatasource(String dsId, String ifaceId) throws Exception {
        StringWriter sw = new StringWriter();
        sw.append("for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where");
        sw.append("  $x//DATAPROVIDER/@id = '" + dsId + "' and ");
        sw.append("  $x//DATAPROVIDER/@interface = '" + ifaceId + "' and ");
        sw.append("  $x//RESOURCE_IDENTIFIER/@value != '" + this.metaWfId + "' ");
        sw.append("return $x//RESOURCE_IDENTIFIER/@value/string()");
        boolean active = !((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(sw.toString()).isEmpty();
        log.info((Object)(" - Updating iface, active status: " + active));
        this.updateIfaceActivationStatus(dsId, ifaceId, active);
    }

    protected void updateIfaceActivationStatus(String dsId, String ifaceId, boolean active) throws Exception {
        ((ISRegistryService)this.registryLocator.getService()).updateProfileNode(dsId, "//INTERFACE[@id = '" + ifaceId + "']/@active", "'" + active + "'");
    }

    public String getMetaWfId() {
        return this.metaWfId;
    }

    public void setMetaWfId(String metaWfId) {
        this.metaWfId = metaWfId;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }
}

