/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectStore;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.objectstore.rmi.MetadataObjectRecord;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class DownloadIntoObjectStoreJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(DownloadIntoObjectStoreJobNode.class);
    private String eprParam;
    private String objectStoreId;
    private String idXpath;
    private String contentDescription;
    private String objectIsInsideEpr;
    private IterableResultSetFactory iterableResultSetFactory;
    private ResultSetClientFactory resultSetClientFactory;
    private ResultsetProgressProvider progressProvider;
    private ProcessCountingResultSetFactory processCountingResultSetFactory;

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getObjectStoreId() {
        return this.objectStoreId;
    }

    public void setObjectStoreId(String objectStoreId) {
        this.objectStoreId = objectStoreId;
    }

    public ProgressProvider getProgressProvider(NodeToken token) {
        return this.progressProvider;
    }

    @Override
    protected String getXqueryForServiceId(NodeToken token) {
        return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='ObjectStoreServiceResourceType']/@value/string()";
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        job.setAction("FEEDOBJECT");
        String eprS = token.getEnv().getAttribute(this.getEprParam());
        job.getParameters().put("obsID", this.getObjectStoreId());
        job.getParameters().put("mime", this.getContentDescription());
        final Iterator client = this.resultSetClientFactory.getClient(eprS).iterator();
        W3CEndpointReference epr = this.iterableResultSetFactory.createIterableResultSet((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new MetadataObjectIterator(client, "//*[local-name()='objIdentifier']", "xml");
            }
        });
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        job.getParameters().put("epr", this.progressProvider.getEpr().toString());
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            @Override
            protected void populateEnv(Env env, Map<String, String> responseParams) {
                log.info((Object)("Number of stored records: " + responseParams.get("total")));
                env.setAttribute("total", responseParams.get("total"));
            }
        };
    }

    public String getObjectIsInsideEpr() {
        return this.objectIsInsideEpr;
    }

    public void setObjectIsInsideEpr(String objectIsInsideEpr) {
        this.objectIsInsideEpr = objectIsInsideEpr;
    }

    @Override
    public ResultsetProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public void setProgressProvider(ResultsetProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public IterableResultSetFactory getIterableResultSetFactory() {
        return this.iterableResultSetFactory;
    }

    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }

    public String getIdXpath() {
        return this.idXpath;
    }

    public void setIdXpath(String idXpath) {
        this.idXpath = idXpath;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public void setContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
    }

    class MetadataObjectIterator
    implements Iterator<String> {
        private Iterator<String> inputIterator;
        private String mime;

        public MetadataObjectIterator(Iterator<String> inputIterator, String xpath, String mime) {
            this.inputIterator = inputIterator;
        }

        @Override
        public boolean hasNext() {
            return this.inputIterator.hasNext();
        }

        @Override
        public String next() {
            try {
                String record = this.inputIterator.next();
                XPath xpath = XPathFactory.newInstance().newXPath();
                InputSource doc = new InputSource(new StringReader(record));
                String identifier = xpath.evaluate(DownloadIntoObjectStoreJobNode.this.getIdXpath(), doc);
                MetadataObjectRecord objectrecord = new MetadataObjectRecord(identifier, record, this.mime);
                return objectrecord.toJSON();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void remove() {
        }
    }
}

