/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class StoreMDStoreRecordsJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(StoreMDStoreRecordsJobNode.class);
    private String eprParam;
    private String mdId;
    private String storingType;
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private ResultsetProgressProvider progressProvider;

    @Override
    protected String getXqueryForServiceId(NodeToken token) {
        return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='MDStoreServiceResourceType']/@value/string()";
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws ResultSetException {
        job.setAction("FEED");
        String eprS = token.getEnv().getAttribute(this.getEprParam());
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), eprS);
        job.getParameters().put("epr", this.progressProvider.getEpr().toString());
        job.getParameters().put("storingType", this.getStoringType());
        job.getParameters().put("mdId", this.getMdId());
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            @Override
            protected void populateEnv(Env env, Map<String, String> responseParams) {
                log.info((Object)("Number of stored records: " + responseParams.get("total")));
                env.setAttribute("total", responseParams.get("total"));
            }
        };
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getStoringType() {
        return this.storingType;
    }

    public void setStoringType(String storingType) {
        this.storingType = storingType;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    @Required
    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    @Override
    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }
}

