/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.index;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateIndexJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(CreateIndexJobNode.class);
    private String outputPrefix = "index_";

    @Override
    protected String getXqueryForServiceId(NodeToken token) {
        return "collection('/db/DRIVER/ServiceResources/IndexServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()";
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) {
        String format = token.getFullEnv().getAttribute("format");
        String layout = token.getFullEnv().getAttribute("layout");
        String interp = token.getFullEnv().getAttribute("interpretation");
        log.info((Object)("preparing CREATE blackboard job: " + format + "-" + layout + "-" + interp));
        job.setAction("CREATE");
        job.getParameters().put("format", format);
        job.getParameters().put("layout", layout);
        job.getParameters().put("interpretation", interp);
    }

    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, final NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            @Override
            protected void populateEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute(CreateIndexJobNode.this.getOutputPrefix() + "format", token.getFullEnv().getAttribute("format"));
                env.setAttribute(CreateIndexJobNode.this.getOutputPrefix() + "layout", token.getFullEnv().getAttribute("layout"));
                env.setAttribute(CreateIndexJobNode.this.getOutputPrefix() + "interpretation", token.getFullEnv().getAttribute("interpretation"));
                env.setAttribute(CreateIndexJobNode.this.getOutputPrefix() + "id", responseParams.get("id"));
            }
        };
    }
}

