/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import com.googlecode.sarasvati.mem.MemNode;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.NodeStatus;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class WorkflowNode
extends MemNode {
    private String workflowId;
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private static final Log log = LogFactory.getLog(WorkflowNode.class);

    public NodeStatus getStatus() {
        try {
            String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(this.workflowId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            if (doc.valueOf("//CONFIGURATION/@start").equalsIgnoreCase("disabled")) {
                return NodeStatus.DISABLED;
            }
            if (doc.selectNodes("//PARAM[@required='true' and string-length(normalize-space(.)) = 0]").isEmpty()) {
                return NodeStatus.CONFIGURED;
            }
            return NodeStatus.NOT_CONFIGURED;
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining wf status", (Throwable)e);
            return NodeStatus.NOT_CONFIGURED;
        }
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }
}

