/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.nodes.SarasvatiJobNode;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AsyncJobNode
extends SarasvatiJobNode {
    private static final Log log = LogFactory.getLog(AsyncJobNode.class);
    private final ExecutorService executor = Executors.newCachedThreadPool();

    @Override
    public void execute(final Engine engine, final NodeToken token) {
        super.execute(engine, token);
        log.info((Object)"executing async node");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    log.debug((Object)("START NODE: " + AsyncJobNode.this.getBeanName()));
                    AsyncJobNode.this.beforeStart(token);
                    String arc = AsyncJobNode.this.execute(token);
                    AsyncJobNode.this.beforeCompleted(token);
                    log.debug((Object)("END NODE (SUCCESS): " + AsyncJobNode.this.getBeanName()));
                    engine.complete(token, arc);
                }
                catch (Throwable e) {
                    log.error((Object)"got exception while executing workflow node", e);
                    log.debug((Object)("END NODE (FAILED): " + AsyncJobNode.this.getBeanName()));
                    AsyncJobNode.this.beforeFailed(token);
                    token.getEnv().setAttribute("system:hasFailed", (Object)true);
                    token.getEnv().setAttribute("system:error", e.getMessage());
                    engine.complete(token, "failed");
                }
            }
        });
    }

    protected abstract String execute(NodeToken var1) throws Exception;

    protected void beforeStart(NodeToken token) {
    }

    protected void beforeCompleted(NodeToken token) {
    }

    protected void beforeFailed(NodeToken token) {
    }
}

