/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.notification;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class EmailDispatcher {
    private String from;
    private String fromName;
    private String cc;
    private String smtpHost;
    private int smtpPort = 587;
    private String smtpUser;
    private String smtpPassword;
    private String baseUrl;
    private static final Log log = LogFactory.getLog(EmailDispatcher.class);
    private BlockingQueue<Message> queue = new LinkedBlockingQueue<Message>();

    public void sendMail(List<String> to, String subject, String template, Map<String, Object> tmplParams) {
        try {
            StringTemplate st = new StringTemplate(template);
            st.setAttributes(tmplParams);
            st.setAttribute("baseUrl", (Object)this.baseUrl);
            Session session = Session.getInstance((Properties)this.obtainProperties(), (Authenticator)this.obtainAuthenticator());
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.from, this.fromName));
            message.setSubject(subject);
            message.setContent((Object)st.toString(), "text/html; charset=utf-8");
            message.setSentDate(new Date());
            for (String s : to) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(s));
            }
            if (this.cc != null && !this.cc.isEmpty()) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(this.cc));
            }
            this.queue.add((Message)message);
            log.info((Object)("Mail to " + Arrays.toString(to.toArray()) + " in queue"));
        }
        catch (Exception e) {
            log.error((Object)"Error sending mail", (Throwable)e);
        }
    }

    public void processMailQueue() {
        Message message;
        while ((message = (Message)this.queue.poll()) != null) {
            try {
                log.info((Object)"Sending mail...");
                Transport.send((Message)message);
                log.info((Object)"...sent");
            }
            catch (MessagingException e) {
                log.error((Object)"Error sending email", (Throwable)e);
                this.queue.add(message);
                return;
            }
        }
        return;
    }

    private void sendWfStatusMail(boolean success, List<String> to, String wfId, String procId, String wfName, Map<String, String> pendingWfs, Map<String, String> responses, String error) {
        try {
            HashMap map = Maps.newHashMap();
            map.put("wfId", wfId);
            map.put("wfName", wfName);
            map.put("procId", procId);
            if (pendingWfs != null && !pendingWfs.isEmpty()) {
                map.put("pendingWfs", pendingWfs);
            }
            if (responses != null && !responses.isEmpty()) {
                map.put("responses", responses);
            }
            if (error != null && !error.isEmpty()) {
                map.put("error", error);
            }
            String subject = success ? "Workflow '" + wfName + "' has been completed successfully" : "Workflow '" + wfName + "' is failed";
            String tmplName = success ? "wf_success.mail.st" : "wf_failed.mail.st";
            String template = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/msro/mail/" + tmplName));
            this.sendMail(to, subject, template, map);
        }
        catch (Exception e) {
            log.error((Object)"Error generating success-mail", (Throwable)e);
        }
    }

    public void sendSuccessMail(List<String> to, String wfId, String procId, String wfName, Map<String, String> pendingWfs, Map<String, String> responses) {
        this.sendWfStatusMail(true, to, wfId, procId, wfName, pendingWfs, responses, "");
    }

    public void sendFailedMail(List<String> to, String wfId, String procId, String wfName, Map<String, String> pendingWfs, Map<String, String> responses, String error) {
        this.sendWfStatusMail(false, to, wfId, procId, wfName, pendingWfs, responses, error);
    }

    private Properties obtainProperties() {
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", this.smtpHost);
        props.put("mail.smtp.port", (Object)this.smtpPort);
        props.put("mail.smtp.auth", Boolean.toString(this.smtpUser != null && !this.smtpUser.isEmpty()));
        return props;
    }

    private Authenticator obtainAuthenticator() {
        if (this.smtpUser == null || this.smtpUser.isEmpty()) {
            return null;
        }
        return new Authenticator(){
            private PasswordAuthentication authentication;
            {
                this.authentication = new PasswordAuthentication(EmailDispatcher.this.smtpUser, EmailDispatcher.this.smtpPassword);
            }

            protected PasswordAuthentication getPasswordAuthentication() {
                return this.authentication;
            }
        };
    }

    public String getFrom() {
        return this.from;
    }

    @Required
    public void setFrom(String from) {
        this.from = from;
    }

    public String getFromName() {
        return this.fromName;
    }

    @Required
    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getCc() {
        return this.cc;
    }

    @Required
    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    @Required
    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSmtpUser() {
        return this.smtpUser;
    }

    public void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Required
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

