/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.sarasvati.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.googlecode.sarasvati.GraphProcess;
import eu.dnetlib.msro.workflows.util.ProcessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class GraphProcessRegistry {
    private static final Log log = LogFactory.getLog(GraphProcessRegistry.class);
    private BiMap<String, GraphProcess> procs = HashBiMap.create();
    private Map<String, Collection<GraphProcess>> byResource = new HashMap<String, Collection<GraphProcess>>();
    private int maxSize;

    public GraphProcess findProcess(String identifier) {
        return (GraphProcess)this.procs.get((Object)identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GraphProcess> findProcessesByResource(String identifier) {
        GraphProcessRegistry graphProcessRegistry = this;
        synchronized (graphProcessRegistry) {
            Collection<GraphProcess> res = this.byResource.get(identifier);
            if (res == null) {
                return new ArrayList<GraphProcess>();
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String associateProcessWithResource(GraphProcess process, String identifier) {
        this.registerProcess(process);
        GraphProcessRegistry graphProcessRegistry = this;
        synchronized (graphProcessRegistry) {
            Collection<GraphProcess> processes = this.findProcessesByResource(identifier);
            processes.add(process);
            this.byResource.put(identifier, processes);
        }
        return identifier;
    }

    public String registerProcess(GraphProcess process) {
        if (this.procs.containsValue((Object)process)) {
            return (String)this.procs.inverse().get((Object)process);
        }
        String id = ProcessUtils.generateProcessId();
        if (this.procs.size() >= this.maxSize) {
            this.removeOldestProcess();
        }
        this.procs.put((Object)id, (Object)process);
        log.info((Object)("Registered proc " + process.getGraph().getName() + " with id " + id));
        return id;
    }

    private void removeOldestProcess() {
        Date oldDate = new Date();
        String oldId = null;
        for (Map.Entry e : this.procs.entrySet()) {
            Date date;
            GraphProcess proc = (GraphProcess)e.getValue();
            if (!proc.isComplete() && !proc.isCanceled() || !(date = ProcessUtils.calculateLastActivityDate(proc)).before(oldDate)) continue;
            oldDate = date;
            oldId = (String)e.getKey();
        }
        if (oldId != null) {
            this.unregisterProcess(oldId);
        }
    }

    public void unregisterProcess(String identifier) {
        GraphProcess process = this.findProcess(identifier);
        this.procs.remove((Object)identifier);
        for (Collection<GraphProcess> processes : this.byResource.values()) {
            processes.remove(process);
        }
    }

    public Collection<String> listIdentifiers() {
        return this.procs.keySet();
    }

    public Map<String, Collection<GraphProcess>> getByResource() {
        return this.byResource;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Required
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

