/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.repohi;

import com.google.common.base.Splitter;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;

public class VerifyDatasourceJobNode
extends SimpleJobNode {
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String expectedInterfaceTypologyPrefixes;
    private String expectedCompliancePrefixes;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String dsId = token.getFullEnv().getAttribute("dataprovider:id");
        String ifaceId = token.getFullEnv().getAttribute("dataprovider:interface");
        this.verifyValue("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/@compliance/string()", this.expectedCompliancePrefixes);
        this.verifyValue("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/@typology/string()", this.expectedInterfaceTypologyPrefixes);
        if (this.isPending(dsId)) {
            return "validateDs";
        }
        return Arc.DEFAULT_ARC;
    }

    private void verifyValue(String xqueryValue, String expected) throws Exception {
        if (expected != null && !expected.isEmpty()) {
            String value = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(xqueryValue);
            for (String s : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)expected)) {
                if (!value.toLowerCase().startsWith(s.toLowerCase())) continue;
                return;
            }
            throw new MSROException("Invalid value: " + value + ", Valid term prefixes are: [" + expected + "]");
        }
    }

    private boolean isPending(String id) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        String query = "/*[.//RESOURCE_IDENTIFIER/@value='" + id + "']//RESOURCE_KIND/@value/string()";
        String res = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
        return res.trim().equals("PendingRepositoryResources");
    }

    public String getExpectedInterfaceTypologyPrefixes() {
        return this.expectedInterfaceTypologyPrefixes;
    }

    public void setExpectedInterfaceTypologyPrefixes(String expectedInterfaceTypologyPrefixes) {
        this.expectedInterfaceTypologyPrefixes = expectedInterfaceTypologyPrefixes;
    }

    public String getExpectedCompliancePrefixes() {
        return this.expectedCompliancePrefixes;
    }

    public void setExpectedCompliancePrefixes(String expectedCompliancePrefixes) {
        this.expectedCompliancePrefixes = expectedCompliancePrefixes;
    }
}

