/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectStore;

import com.google.common.collect.Sets;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Required;

public class RetrieveMdStoreId
extends SimpleJobNode {
    private String metadataFormat;
    private String interpretation;
    private String providerId;
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String query = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//PARAM/@name=\"mdId\" and $x//PARAM/@name=\"providerId\" and $x//PARAM[./@name=\"providerId\"]/text()=\"%s\")return distinct-values($x//PARAM[./@name=\"mdId\"])";
        List result = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(String.format(query, this.providerId));
        if (result.size() <= 0) {
            throw new RuntimeException("there is no mdStore Associated to the provider " + token.getEnv().getAttribute(this.getProviderId()));
        }
        HashSet metadataIds = Sets.newHashSet((Iterable)result);
        String id = this.getRightMetadataId(metadataIds);
        token.getEnv().setAttribute("mdId", id);
        token.getEnv().setAttribute("mdFormat", this.getMetadataFormat());
        return Arc.DEFAULT_ARC;
    }

    private String getRightMetadataId(Iterable<String> ids) throws ISLookUpException {
        String query = "concat(//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value=\"%s\"]//METADATA_FORMAT/text(), \"::<<>>::\",//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value=\"%s\"]//METADATA_FORMAT_INTERPRETATION/text())";
        for (String id : ids) {
            String[] values;
            List results = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(String.format(query, id, id));
            if (results.size() <= 0 || !this.metadataFormat.equals((values = ((String)results.get(0)).split("::<<>>::"))[0]) || !this.interpretation.equals(values[1])) continue;
            return id;
        }
        return null;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    @Required
    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    @Required
    public void setMetadataFormat(String metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }
}

