/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.db;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class UpdateDbJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private String db;
    private String dbParam;
    private String eprParam;
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private ResultsetProgressProvider progressProvider;
    private static final Log log = LogFactory.getLog(UpdateDbJobNode.class);

    @Override
    protected String getXqueryForServiceId(NodeToken token) {
        return "for $x in collection('/db/DRIVER/ServiceResources/DatabaseServiceResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()";
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        if (this.db == null || this.db.isEmpty()) {
            this.db = token.getEnv().getAttribute(this.getDbParam());
        }
        log.info((Object)("preparing blackboard job to update DB: " + this.db));
        String epr = token.getEnv().getAttribute(this.getEprParam());
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        job.setAction("IMPORT");
        job.getParameters().put("db", this.db);
        job.getParameters().put("epr", this.progressProvider.getEpr().toString());
    }

    @Override
    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    @Required
    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    public String getDbParam() {
        return this.dbParam;
    }

    public void setDbParam(String dbParam) {
        this.dbParam = dbParam;
    }
}

