/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.collect;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class CollectRecordsJobNode
extends SimpleJobNode {
    private ServiceLocator<CollectorService> collectorLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String datasourceId;
    private String datasourceInterface;
    private String eprParam;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(this.datasourceId);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + this.datasourceInterface + "']");
        InterfaceDescriptor interfaceDescriptor = InterfaceDescriptor.newInstance((Node)ifcNode);
        W3CEndpointReference epr = ((CollectorService)this.collectorLocator.getService()).collect(interfaceDescriptor);
        token.getEnv().setAttribute(this.getEprParam(), epr.toString());
        return Arc.DEFAULT_ARC;
    }

    public ServiceLocator<CollectorService> getCollectorLocator() {
        return this.collectorLocator;
    }

    @Required
    public void setCollectorLocator(ServiceLocator<CollectorService> collectorLocator) {
        this.collectorLocator = collectorLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

