/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.notification;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.notification.EmailDispatcher;
import eu.dnetlib.msro.workflows.sarasvati.loader.WorkflowExecutor;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class WfDependencyLauncherNotificationHandler
extends AbstractSubscriptionAction {
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    private WorkflowExecutor workflowExecutor;
    @Resource
    private EmailDispatcher emailDispatcher;
    private static final Log log = LogFactory.getLog(WorkflowExecutor.class);

    public void notified(String subscrId, String topic, String rsId, String profile) {
        block11: {
            SAXReader reader = new SAXReader();
            try {
                Document doc = reader.read((Reader)new StringReader(profile));
                List<String> emails = this.calculateEmails(rsId);
                String procId = doc.valueOf("//LAST_EXECUTION_ID");
                String wfName = doc.valueOf("//WORKFLOW_NAME");
                boolean success = doc.valueOf("//LAST_EXECUTION_STATUS").equals("SUCCESS");
                HashMap responses = Maps.newHashMap();
                for (Object o : doc.selectNodes("//LAST_EXECUTION_OUTPUT")) {
                    Node n = (Node)o;
                    responses.put(n.valueOf("@name"), n.getText());
                }
                if (!success) {
                    log.info((Object)("Last execution of " + rsId + " failed, dependencies NOT STARTED"));
                }
                String query = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType')//WORKFLOW[@id='" + rsId + "']/WORKFLOW let $y := /RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = $x/@id] " + "where $y//CONFIGURATION/@start != 'disabled' return concat ($x/@id , ' @@@ ', $x/@name , ' @@@ ', $y//CONFIGURATION/@start)";
                try {
                    HashMap pendingWfs = Maps.newHashMap();
                    for (String s : ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query)) {
                        String[] arr = s.split("@@@");
                        String id = arr[0].trim();
                        String name = arr[1].trim();
                        boolean manual = arr[2].trim().toLowerCase().equals("manual");
                        if (success && !manual) {
                            try {
                                String pid = this.workflowExecutor.startProcess(id);
                                log.info((Object)("PROC " + pid + " of WF " + id + " STARTED AS CHILD OF " + rsId));
                            }
                            catch (Exception e) {
                                log.error((Object)("Error starting wf: " + id));
                            }
                            continue;
                        }
                        pendingWfs.put(id, name);
                    }
                    if (emails.isEmpty()) break block11;
                    if (success) {
                        this.emailDispatcher.sendSuccessMail(emails, rsId, procId, wfName, pendingWfs, responses);
                        break block11;
                    }
                    String error = doc.valueOf("//LAST_EXECUTION_ERROR");
                    this.emailDispatcher.sendFailedMail(emails, rsId, procId, wfName, pendingWfs, responses, error);
                }
                catch (ISLookUpException e) {
                    log.error((Object)("Error executing xquery: " + query), (Throwable)e);
                }
            }
            catch (DocumentException e) {
                log.error((Object)("Error parsing profile with id " + rsId + ": " + profile));
            }
        }
    }

    private List<String> calculateEmails(String id) {
        ArrayList list = Lists.newArrayList();
        try {
            for (String val : ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("//ADMIN_EMAIL[..//WORKFLOW/@id='" + id + "']/text()")) {
                for (String s : Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)val)) {
                    list.add(s);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error searching email adresses", (Throwable)e);
        }
        return list;
    }
}

