package eu.dnetlib.msro.workflows.nodes.transform;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class MdBuilderJobNode extends SimpleJobNode {

	@javax.annotation.Resource(name = "mdBuilderTemplateXslt")
	private Resource mdBuilderTemplateXslt;

	private String inputEprParam;
	private String outputEprParam;
	private String datasourceId;
	private String datasourceInterface;

	private XSLTMappedResultSetFactory xsltMappedResultSetFactory;

	@javax.annotation.Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String inputEpr = token.getEnv().getAttribute(inputEprParam);
		if ((inputEpr == null) || inputEpr.isEmpty()) throw new MSROException("InputEprParam (" + inputEprParam + ") not found in ENV");

		String concreteXslt = IOUtils.toString(getMdBuilderTemplateXslt().getInputStream());
		String xQuery = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') "
				+ "return $x//INTERFACE[@id='{interfaceId}']/INTERFACE_EXTRA_FIELD[@name='metadata_identifier_path']/string()";
		xQuery = xQuery.replace("{interfaceId}", datasourceInterface);
		concreteXslt = concreteXslt.replace("{metadata_identifier_path}", lookupLocator.getService().getResourceProfileByQuery(xQuery)).replace(
				"{datasourceId}", datasourceId);

		final W3CEndpointReference epr = xsltMappedResultSetFactory.createMappedResultSet((new EPRUtils()).getEpr(inputEpr), concreteXslt);

		token.getEnv().setAttribute(outputEprParam, epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
		return xsltMappedResultSetFactory;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	@Required
	public void setXsltMappedResultSetFactory(final XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
		this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
	}

	public Resource getMdBuilderTemplateXslt() {
		return mdBuilderTemplateXslt;
	}

	public void setMdBuilderTemplateXslt(final Resource mdBuilderTemplateXslt) {
		this.mdBuilderTemplateXslt = mdBuilderTemplateXslt;
	}

}
