package eu.dnetlib.msro.workflows.nodes.mdstore;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FetchMDStoreRecordsJobNode extends SimpleJobNode {

	private ServiceLocator<MDStoreService> mdstoreLocator;

	private String mdId;
	private String mdFormat;
	private String eprParam;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		if (getMdId() == null) {
			setMdId(token.getEnv().getAttribute("mdId"));
		}
		if (getMdFormat() == null) {
			setMdFormat(token.getEnv().getAttribute("mdFormat"));
		}

		final W3CEndpointReference epr = mdstoreLocator.getService().deliverMDRecords(getMdId(), "", "", "");
		token.getEnv().setAttribute(getEprParam(), epr.toString());
		return Arc.DEFAULT_ARC;
	}

	public ServiceLocator<MDStoreService> getMdstoreLocator() {
		return mdstoreLocator;
	}

	@Required
	public void setMdstoreLocator(final ServiceLocator<MDStoreService> mdstoreLocator) {
		this.mdstoreLocator = mdstoreLocator;
	}

	public String getMdId() {
		return mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getMdFormat() {
		return mdFormat;
	}

	public void setMdFormat(final String mdFormat) {
		this.mdFormat = mdFormat;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}
}
