package eu.dnetlib.msro.workflows.nodes.index;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public class DeleteIndexJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(DeleteIndexJobNode.class);

	private String indexId;

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "collection('/db/DRIVER/ServiceResources/IndexServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()";
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		log.info("deleting index id = " + getIndexId());

		job.setAction("DELETE");
		job.getParameters().put("id", getIndexId());

	}

	public String getIndexId() {
		return indexId;
	}

	public void setIndexId(final String indexId) {
		this.indexId = indexId;
	}
}
