package eu.dnetlib.msro.workflows.nodes.index;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;

public class CreateIndexJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(CreateIndexJobNode.class);

	private String outputPrefix = "index_";

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "collection('/db/DRIVER/ServiceResources/IndexServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()";
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) {
		final String format = token.getFullEnv().getAttribute("format");
		final String layout = token.getFullEnv().getAttribute("layout");
		final String interp = token.getFullEnv().getAttribute("interpretation");

		log.info("preparing CREATE blackboard job: " + format + "-" + layout + "-" + interp);

		job.setAction("CREATE");
		job.getParameters().put("format", format);
		job.getParameters().put("layout", layout);
		job.getParameters().put("interpretation", interp);
	}

	public String getOutputPrefix() {
		return outputPrefix;
	}

	public void setOutputPrefix(final String outputPrefix) {
		this.outputPrefix = outputPrefix;
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Engine engine, final NodeToken token) {
		return new BlackboardWorkflowJobListener(engine, token) {

			@Override
			protected void populateEnv(final Env env, final Map<String, String> responseParams) {
				env.setAttribute(getOutputPrefix() + "format", token.getFullEnv().getAttribute("format"));
				env.setAttribute(getOutputPrefix() + "layout", token.getFullEnv().getAttribute("layout"));
				env.setAttribute(getOutputPrefix() + "interpretation", token.getFullEnv().getAttribute("interpretation"));
				env.setAttribute(getOutputPrefix() + "id", responseParams.get("id"));
			}
		};
	}

}
