package eu.dnetlib.msro.workflows.nodes.harvest.fs;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.nodes.blackboard.OngoingBlackboardWorkflowJobListener;

import java.util.*;

public class StartHarvestFSJobNode extends BlackboardJobNode {
	/**
	 * Logger.
	 */
	private static final Log log = LogFactory.getLog(StartHarvestFSJobNode.class);

	/**
	 * lookup locator.
	 */
	@Resource(name="lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	private static final String protocol = "filesystem";
	
	private String datasourceId;
	private String username;
	private String password;
	private String filter;
	private String eprParam;
	private String datasourceInterface;
	private String format;
	
	@Override
	protected String getXqueryForServiceId(NodeToken token) {
		return "collection('/db/DRIVER/ServiceResources/HarvestingServiceResourceType')/RESOURCE_PROFILE"
		+ "[.//SERVICE_PROPERTIES/PROPERTY[@key='protocol']/@value = '" + protocol + "']//RESOURCE_IDENTIFIER/@value/string()";
	}

	@Override
	protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
		job.setAction("LISTRECORDS");

		if (datasourceId == null || datasourceId.isEmpty()) {
			throw new MSROException("Missing field datasourceId");
		} else {
			job.getParameters().put("repository_id", getDatasourceId());
		}
		
		if (datasourceInterface == null || datasourceInterface.isEmpty()) {
			throw new MSROException("Missing field datasourceInterface");
		} else {
			job.getParameters().put("base_url", obtainBaseUrl());
		}
		
		if (format == null || format.isEmpty()) {
			throw new MSROException("Missing field format");
		} else {
			job.getParameters().put("inputFormat",  format);
		}
		
		if (username != null && !username.isEmpty()) {
			job.getParameters().put("username", getUsername());
		}

		if (password != null && !password.isEmpty()) {
			job.getParameters().put("password", getPassword());
		}

		if (filter != null && !filter.isEmpty()) {
			job.getParameters().put("filter", getFilter());
		}
		
	}
	
	private String obtainBaseUrl() throws ISLookUpDocumentNotFoundException, ISLookUpException {
		String query = "/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + getDatasourceId() + "']" +
				"//INTERFACE[@label='" + getDatasourceInterface() + 
				"' and ./ACCESS_PROTOCOL = '" + protocol +
				"' and .//FORMAT = '" + getFormat() + "']/BASE_URL/text()";
        
		log.info("Executing query: " + query);
		
		return lookupLocator.getService().getResourceProfileByQuery(query);
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
		return new OngoingBlackboardWorkflowJobListener(engine, token) {
			@Override
			protected void populateEnv(final Env env, final Map<String, String> responseParams) {
				log.info("Obtained epr: " + responseParams.get("rs_epr"));
				env.setAttribute(getEprParam(), responseParams.get("rs_epr"));
			}
		};
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getFilter() {
		return filter;
	}

	public void setFilter(String filter) {
		this.filter = filter;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(String eprParam) {
		this.eprParam = eprParam;
	}

	
	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}
	
}
