package eu.dnetlib.msro.workflows.nodes.collect;

import java.io.StringReader;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class CollectRecordsJobNode extends SimpleJobNode {

	private ServiceLocator<CollectorService> collectorLocator;
	private ServiceLocator<ISLookUpService> lookupLocator;

	private String datasourceId;
	private String datasourceInterface;
	private String eprParam;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String profile = lookupLocator.getService().getResourceProfile(datasourceId);
		final Document doc = (new SAXReader()).read(new StringReader(profile));
		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + datasourceInterface + "']");

		final InterfaceDescriptor interfaceDescriptor = InterfaceDescriptor.newInstance(ifcNode);

		final W3CEndpointReference epr = collectorLocator.getService().collect(interfaceDescriptor);

		token.getEnv().setAttribute(getEprParam(), epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public ServiceLocator<CollectorService> getCollectorLocator() {
		return collectorLocator;
	}

	@Required
	public void setCollectorLocator(final ServiceLocator<CollectorService> collectorLocator) {
		this.collectorLocator = collectorLocator;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	@Required
	public void setLookupLocator(final ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
