package eu.dnetlib.msro.workflows.nodes;

import java.io.StringReader;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

import com.googlecode.sarasvati.mem.MemNode;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;

public class WorkflowNode extends MemNode {

	private String workflowId;

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	private static final Log log = LogFactory.getLog(WorkflowNode.class);

	public NodeStatus getStatus() {
		try {
			final String profile = lookupLocator.getService().getResourceProfile(workflowId);
			final Document doc = (new SAXReader()).read(new StringReader(profile));
			if (doc.valueOf("//CONFIGURATION/@start").equalsIgnoreCase("disabled")) {
				return NodeStatus.DISABLED;
			} else if (doc.selectNodes("//PARAM[@required='true' and string-length(normalize-space(.)) = 0]").isEmpty()) {
				return NodeStatus.CONFIGURED;
			} else {
				return NodeStatus.NOT_CONFIGURED;
			}
		} catch (Exception e) {
			log.error("Error obtaining wf status", e);
			return NodeStatus.NOT_CONFIGURED;
		}
	}

	public String getWorkflowId() {
		return workflowId;
	}

	public void setWorkflowId(final String workflowId) {
		this.workflowId = workflowId;
	}

}
