package eu.dnetlib.msro.workflows.metawf;

import java.io.IOException;
import java.util.Map;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class WorkflowProfileCreator {

	private static final Resource wfTemplate = new ClassPathResource("/eu/dnetlib/msro/workflows/templates/workflow.xml.st");

	public static String generateProfile(final String name, final String type, final Map<String, String> params, final Resource confTemplate)
			throws IOException {

		final StringTemplate conf = new StringTemplate(IOUtils.toString(confTemplate.getInputStream()));
		conf.setAttribute("params", params);

		final StringTemplate profile = new StringTemplate(IOUtils.toString(wfTemplate.getInputStream()));
		profile.setAttribute("name", name);
		profile.setAttribute("type", type);
		profile.setAttribute("priority", WorkflowsConstants.DEFAULT_WF_PRIORITY);
		profile.setAttribute("conf", conf.toString());

		return profile.toString();
	}
}
