var module = angular.module('modalSynonym', []);

module.directive('modalSynonym', function(){
	return {
		restrict: 'E',
		templateUrl: '../resources/html/vocabularies/modalSynonym.html',
		controller: function($scope){
			$scope.showSynonymModal = function(term, synonym) {
				$scope.selectedTermIndex = $scope.entries.indexOf(term);
				$scope.selectedSynonymIndex = $scope.entries[$scope.selectedTermIndex].synonyms.indexOf(synonym);
				if (synonym != null) {
					// edit existing synonym
					$scope.modalSynonym.refTerm = $scope.entries[$scope.selectedTermIndex].englishName;
					$scope.modalSynonym.term = $scope.entries[$scope.selectedTermIndex].synonyms[$scope.selectedSynonymIndex].term;
					$scope.modalSynonym.encoding = $scope.entries[$scope.selectedTermIndex].synonyms[$scope.selectedSynonymIndex].encoding;
				} else {
					// new synonym
					$scope.modalSynonym.refTerm = $scope.entries[$scope.selectedTermIndex].englishName;
					$scope.modalSynonym.term = '';
					$scope.modalSynonym.encoding = '';
				}
				$('#synonymModal').modal();
			}
			
			$scope.editSynonym = function() {
				if ($scope.selectedSynonymIndex == -1) {
					$scope.entries[$scope.selectedTermIndex].synonyms.push({
						"term" : $scope.modalSynonym.term,
						"encoding" : $scope.modalSynonym.encoding
					});
				} else {
					$scope.entries[$scope.selectedTermIndex].synonyms[$scope.selectedSynonymIndex].term = $scope.modalSynonym.term;
					$scope.entries[$scope.selectedTermIndex].synonyms[$scope.selectedSynonymIndex].encoding = $scope.modalSynonym.encoding;
				}
				// dismiss modal
				$('.modal').modal('hide');
				showPermanotice("Uncommitted changes!");
			}
		},
		controllerAs: 'modalSynonym'
	}
});