var module = angular.module('modalTerm', []);

module.directive('modalTerm', function() {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/vocabularies/modalTerm.html',
		controller: function($scope){
			$scope.showTermModal = function(term) {
				$scope.selectedTermIndex = $scope.entries.indexOf(term);
				if (term != null) {
					// edit existing term
					$scope.modalTerm.englishName = term.englishName;
					$scope.modalTerm.nativeName = term.nativeName;
					$scope.modalTerm.encoding = term.encoding;
					$scope.modalTerm.code = term.code;
				} else {
					// edit new term
					$scope.modalTerm.englishName = '';
					$scope.modalTerm.nativeName = '';
					$scope.modalTerm.encoding = '';
					$scope.modalTerm.code = '';
				}
				$('#termModal').modal();
			}
			
			$scope.editTerm = function() {
				if ($scope.selectedTermIndex == -1) {
					// new term
					$scope.entries.push({
						"englishName" : $scope.modalTerm.englishName,
						"nativeName" : $scope.modalTerm.nativeName,
						"encoding" : $scope.modalTerm.encoding,
						"synonyms" : [],
						"code" : $scope.modalTerm.code
					});
				} else {
					// term update
					$scope.entries[$scope.selectedTermIndex].englishName = $scope.modalTerm.englishName;
					$scope.entries[$scope.selectedTermIndex].nativeName = $scope.modalTerm.nativeName;
					$scope.entries[$scope.selectedTermIndex].encoding = $scope.modalTerm.encoding;
					$scope.entries[$scope.selectedTermIndex].code = $scope.modalTerm.code;
				}
				// dismiss modal
				$('.modal').modal('hide');
				showPermanotice("Uncommitted changes!");
			}
		},
		controllerAs: 'modalTerm'
	};
	
});