var repoControllers = angular.module('repoControllers', []);

repoControllers.controller('repoBrowseCtrl', [
	'$scope', '$http', '$timeout', '$sce', '$location',
	function ($scope, $http, $timeout, $sce, $location) {
		common_init($scope, $http, $sce, $location);
		$scope.repoBrowseFields = getBrowseFields();
		$scope.filterBrowseData = { filterText: '' };
		$scope.repoBrowseData = { 'data' : [] };
		
		$scope.gridBrowseData = {
				data: 'repoBrowseData.data',
				enableRowSelection: false,
				enableCellEditOnFocus: false,
				enableHighlighting: true,
				filterOptions: $scope.filterBrowseData,
				sortInfo: { fields: ['value'], directions: ['desc'] },
				columnDefs: [
				             {field: 'name', displayName: 'Name', cellTemplate: '<div class="ngCellText"><a href="javascript:void(0)" ng-click="browseApis(repoBrowseData.id, row.getProperty(\'id\'))">{{row.getProperty(col.field)}}</a></div>' },
				             {field: 'value', displayName: '# datasources', width: '20%', headerClass: 'text-right', cellClass: 'text-right' }
				             ]
		};
		
		$scope.searchApis = function (text) {
			$scope.go('/list/__SEARCH__/' + text); 
		} 
		
		$scope.browseApis = function (field, value) {
			$('#showRepoBrowseData').modal('hide');
			$scope.showSpinner();
			$timeout(function() {
				$scope.go('/list/' + field + '/' + value);
			}, 1500);
		}
		
		$scope.browseRepoField = function(field) {
			$scope.repoBrowseData = {
				'label' : field.label,
				'id' :    field.id,
				'data'  : []
			};
			$scope.showSpinner();
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
	      	$http.post('browseRepoField.do', $.param({
	      		'xpath'      : field.xpath,
	      		'vocabulary' : field.vocabulary
	      	})).success(
	            function(data) {
	            	$scope.hideSpinner();
	            	$scope.repoBrowseData.data = data;
	            	
	            	$('#showRepoBrowseData').modal('show');
	            	
	            }
	        ).error(
	            function() {
	            	$scope.showError('Something really bad must have happened to our fellow hamster..');
	            	$scope.hideSpinner();
	            }
	        );
		};
	}
]);

repoControllers.controller('repoListCtrl', [
	'$scope', '$http', '$timeout', '$sce', '$routeParams', '$location',
	function ($scope, $http, $timeout, $sce, $routeParams, $location) {
		common_init($scope, $http, $sce, $location);

		$scope.apis = [];
		$scope.filterApis = { filterText: '' };
		$scope.gridApis = { 
				data: 'apis',
				enableRowSelection: false,
				enableCellEditOnFocus: false,
				enableHighlighting: true,
				filterOptions: $scope.filterApis,
				columnDefs: [
				             {field: 'repoCountry' , displayName: 'Country',               width: '80px',  headerClass: 'text-center', cellTemplate: '<ng-repo-country-cell />' },
				             {field: 'repoName'    , displayName: 'Datasource Api',        cellTemplate: '<ng-reponame-cell />' },
				             {field: 'repoPrefix'  , displayName: 'Namespace Prefix',      width: '150px', headerClass: 'text-center', cellClass: 'text-center' },
				             {field: 'protocol'    , displayName: 'Protocol',        	   width: '160px', headerClass: 'text-center', cellClass: 'text-center' },
				             {field: 'aggrDate'    , displayName: 'Last Aggregation Date', width: '200px', headerClass: 'text-center', cellTemplate: '<ng-aggr-date-cell />' },
				             {field: 'aggrTotal'   , displayName: 'Total',                 width: '80px',  headerClass: 'text-center', cellTemplate: '<ng-aggr-total-cell />' }
				            ]
		};
		
    	$scope.currentApiSelectionParam = $routeParams.param;
    	$scope.currentApiSelectionValue = $routeParams.value;
    	
    	$scope.updateApis = function(refresh) {
			$scope.showSpinner();
			
			var xpath = '';
			angular.forEach(getBrowseFields(), function(f) {
        		if (f.id == $scope.currentApiSelectionParam) {
        			xpath = f.xpath;
        		}
        	});
						    
			var params = {
				'param' : $scope.currentApiSelectionParam,
				'value' : $scope.currentApiSelectionValue,
				'xpath' : xpath
			};
			if (refresh) {
				params.refresh = 1;
			}

			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('listApis.do', $.param(params)).success(
	            function(data) {
	            	$scope.hideSpinner();
	            	$scope.apis = data;
	            	$scope.resizeMainElement(document.getElementById('apisTable'));
	            }
	        ).error(
	            function() {
	            	$scope.showError('Something really bad must have happened to our fellow hamster..');
	            	$scope.hideSpinner();
	            }
	        );
    	};
    		
		$scope.showApi = function (repoId, ifaceId) {
			$scope.go('/api/' + repoId + '/' + ifaceId + "/ALL/ALL"); 
		}
		
		window.onresize = function() {
			var elem = document.getElementById('apisTable');
			if (elem) {
				angular.element(elem).scope().resizeMainElement(elem);
			}
		};
    	
    	$scope.updateApis(false);
	}
]);

repoControllers.controller('repoApiCtrl', [
	'$scope', '$http', '$timeout', '$sce', '$routeParams', '$location',
	function ($scope, $http, $timeout, $sce, $routeParams, $location) {
		common_init($scope, $http, $sce, $location);
		
		commonInitialize($scope, $http, $sce);
		wf_init($scope, $http, $sce);
		
		$scope.availableRepohiWfs = getAvailableRepohiWfs();
		$scope.compatibilityLevels = getCompatibilityLevels();
    			
		$scope.currentRepoApi = {};
		$scope.currentSets = [];
		$scope.selectedSets = [];
    	
    	$scope.loadApi = function() {
    		$scope.showSpinner();
    		$(".btnRefreshApi").attr("disabled", "disabled");
    		$http.get('repoApi.get?repoId=' + $routeParams.repoId + "&ifaceId=" +  $routeParams.ifaceId)
            .success(
                function(data) {
                	$scope.currentRepoApi = data;
                	$scope.metaworkflows = data.metaWFs;
                	if (data.protocol == 'oai') {
    	            	var found = false;
    	            	angular.forEach(data.accessParams, function(param, pos){
    	                    if (param.name == 'set') {
    	                    	$scope.listSets($scope.currentRepoApi.accessParams);
    	                    }
    	        		});
                	}
                	$scope.hideSpinner(); 
                	            	
                	$(".btnRefreshApi").removeAttr("disabled");
                	
                	if ($routeParams.metawf != 'ALL' && $routeParams.wf != 'ALL') {
                		$scope.getAtomicWorkflowAndMetaWf($routeParams.metawf, $routeParams.wf);
                		$timeout(function() {
                			$("#collapse_" + $routeParams.metawf.substring(0, 36)).collapse('show');
                		}, 2000);
                	}
                }
            ).error(
                function() {
                	$scope.showError('Something really bad must have happened to our fellow hamster..');
                	$scope.hideSpinner();
                }
            );
    	};
    	
		$scope.newDataProviderWorkflow = function (wf) {
			
			if (wf == undefined) {
				$scope.showError('Please choose a workflow !');
	    		return;
			}
			
			$scope.showSpinner();
	
			$scope.metaworkflows.push({"id":"","name":"Waiting...","status":"MISSING","progress":0});
	    				
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('repoMetaWf.new', $.param({
				'wf'    : wf,
				'iface' : $scope.currentRepoApi.id,
				'id'    : $scope.currentRepoApi.repoId, 
				'name'  : $scope.currentRepoApi.repoName
			})).success(
	       			function(data) {
	       				$scope.hideSpinner();
	       				$(".btnRefreshApi").attr("disabled", "disabled");
	       				$timeout(function () { $scope.loadApi() }, 7000);
		            }
	       	).error(
	       			function() {
	       				$scope.showError('Something really bad must have happened to our fellow hamster..');
	       				$scope.hideSpinner();
		           }
	       	);
		};
		
		$scope.destroyDataProviderWorkflow = function (metaWf) {
			
			if (metaWf.destroyWorkflow == undefined) {
				$scope.showError('Destroy wf is missing !');
	    		return;
			}
			
			if (!confirm("Are you sure ?")) {
				return;
			}
					
			$scope.showSpinner();
			
			metaWf.deleting = true;
			
			$http.get('repoMetaWf.destroy?destroyWf=' + metaWf.destroyWorkflow)
	       	.success(
	       			function(data) {
	       				$scope.hideSpinner();
	       				$(".btnRefreshApi").attr("disabled", "disabled");
	       				$timeout(function () { $scope.loadApi() }, 7000);
		            }
	       	).error(
	       			function() {
	       				$scope.showError('Something really bad must have happened to our fellow hamster..');
	       				$scope.hideSpinner();
		           }
	       	);
		};
		
		$scope.testOAI = function (params) {
			angular.forEach(params, function(param, pos){
	            if (param.name == 'baseUrl') {
	            	location.href = "oaiExplorer.do?oaiBaseUrl=" + param.value;
	            }
			});
		}
	
		$scope.updateRepoApi = function(params) {
			$scope.showSpinner();
	
			var map = {};
			angular.forEach(params, function(param, pos){
	            if (param.name) {
	            	map[param.name] = param.value
	            }
			});
			
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
	        $http.post('repoApi.update', $.param({
	      		'id'    : $scope.currentRepoApi.repoId,
	      		'iface' : $scope.currentRepoApi.id,
	      		'accessParams' : JSON.stringify(map)
	      	})).success(function(data) {
	      		$scope.showNotification('Api correctly saved !');
	        	$scope.loadApi(); 
	        }).error(function() {
	        	$scope.showError('Something really bad must have happened to our fellow hamster..');
	        	$scope.hideSpinner();
	        });
		};
		
		
		$scope.updateSets = function(selection, accessParams) {
			var s = selection.join();
			angular.forEach(accessParams, function(param, pos){
	            if (param.name == 'set') {
	            	param.value = s;
	            }
			});
		}
		
		$scope.listSets = function(accessParams) {
			var baseUrl = '';
			
			$scope.selectedSets = [];
			$scope.currentSets = [];
			
			angular.forEach(accessParams, function(param, pos){
	            if (param.name == 'baseUrl') {
	            	baseUrl = param.value
	            }
	            if (param.name == 'set') {
	            	$scope.selectedSets = param.value.split(",");
	            }
			});
			
			if (!baseUrl) {
				$scope.showError("baseUrl param is missing");
				return;
			}

			$scope.showSpinner();
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
	        $http.post("listValidValuesForParam.do", $.param({
	        	'protocol' : 'oai',
	        	'param'    : 'set',
	        	'baseUrl'  : baseUrl
	        })).success(function(data) {
				$scope.hideSpinner();
	        	$scope.currentSets = data;
	        	angular.forEach($scope.currentSets, function(curr, pos1) {
		        	angular.forEach($scope.selectedSets, function(sel, pos2) {
		        		if (curr.id.trim() == sel.trim()) {
		        			curr.selected = true;
		        		}
		        	});
				});
	        }).error(function() {
				$scope.hideSpinner();
				$scope.showError("baseUrl param is missing");
			});
	        
		};
		
		
		$scope.verifyMetaWf = function(ds, wf) {
			var compliance = '';
			var type = '';
			angular.forEach(ds.commonParams, function(p,pos) {
	        	if (p.id == 'compliance') {
	        		compliance = p.value;
	        	}
	        	if (p.id == 'typology') {
	        		type = p.value;
	        	}
			});
			
			return (compliance && type && $scope.isValidTerm(compliance, wf.compliances) && $scope.isValidTerm(type, wf.ifaceTypes)); 
		}

		$scope.isValidTerm = function(term, list) {
			
			if (list.length == 0) {
				return true;
			}
			var res = false;
			angular.forEach(list, function(curr,pos) {
	        	if (term.lastIndexOf(curr, 0) === 0) { // implementation of term.startsWith(curr)
	        		res = true;
	        	}
			});
			return res;
		}

		$scope.overrideApiCompliance = function(level) {
			$scope.showSpinner();
			$http.get('repoApiCompliance.update?id=' + $scope.currentRepoApi.repoId + '&iface=' + $scope.currentRepoApi.id + '&compliance=' + level)
	        .success(
	        		function(data) {
	        			$scope.hideSpinner();
	        			$scope.showNotification('Api correctly updated !');
	        			$scope.loadApi(); 
	        		}
	        ).error(
	        		function() {
	        			$scope.showError('Something really bad must have happened to our fellow hamster..');
	        			$scope.hideSpinner();
	        		}
	        );
		}
		
		$scope.resetApiCompliance = function() {
			$scope.showSpinner();
			$http.get('repoApiCompliance.reset?id=' + $scope.currentRepoApi.repoId + '&iface=' + $scope.currentRepoApi.id)
	        .success(
	        		function(data) {
	        			$scope.hideSpinner();
	        			$scope.showNotification('Api correctly updated !');
	        			$scope.loadApi(); 
	        		}
	        ).error(
	        		function() {
	        			$scope.showError('Something really bad must have happened to our fellow hamster..');
	        			$scope.hideSpinner();
	        		}
	        );
		}
				
    	$scope.loadApi();
	}
		
 ]);

