/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.ProtocolDescriptor;
import eu.dnetlib.data.collector.rmi.ProtocolParameter;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoInterfaceEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoMapEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoMetaWfEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.SimpleParamEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.SimpleRepoInterfaceEntry;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;

public class RepoUIUtils {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private ClassPathResource browseRepoApisQueryTmpl = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/repositories/templates/browseRepoApis.xquery.st");
    private ClassPathResource getRepoApiQueryTmpl = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/repositories/templates/getRepoApi.xquery.st");
    private ClassPathResource findRepoApisQueryTmpl = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/repositories/templates/findRepoApis.xquery.st");
    private ClassPathResource findReposQueryTmpl = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/repositories/templates/findRepos.xquery.st");
    private ClassPathResource findReposMapQuery = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/repositories/templates/findReposMap.xquery");
    private static final Log log = LogFactory.getLog(RepoUIUtils.class);
    private String browseFieldsJson;
    private Map<String, List<ProtocolParameter>> parametersMap = Maps.newHashMap();

    public List<SimpleParamEntry> browseRepoField(String xpath, String vocabulary) throws Exception {
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.browseRepoApisQueryTmpl.getInputStream()));
        st.setAttribute("xpath", (Object)xpath);
        Map<String, String> voc = this.getVocabulary(vocabulary);
        ArrayList list = Lists.newArrayList();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(st.toString())) {
            String[] arr = s.split("@-@-@");
            String id = arr[0].trim();
            String count = arr[1].trim();
            list.add(new SimpleParamEntry(id, this.findLabel(id, voc), count));
        }
        return list;
    }

    public List<SimpleRepoInterfaceEntry> listApis(String param, String value, String xpath) throws Exception {
        StringTemplate st = new StringTemplate();
        if (param.equalsIgnoreCase("__search__")) {
            st.setTemplate(IOUtils.toString((InputStream)this.findRepoApisQueryTmpl.getInputStream()));
            st.setAttribute("cond", (Object)("contains(../..//(*|@*)/lower-case(.), '" + StringEscapeUtils.escapeXml((String)value.toLowerCase()) + "')"));
        } else {
            st.setTemplate(IOUtils.toString((InputStream)this.findRepoApisQueryTmpl.getInputStream()));
            st.setAttribute("cond", (Object)(xpath + "='" + StringEscapeUtils.escapeXml((String)value) + "'"));
        }
        String query = st.toString();
        final SAXReader reader = new SAXReader();
        List list = Lists.transform((List)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query), (Function)new Function<String, SimpleRepoInterfaceEntry>(){

            public SimpleRepoInterfaceEntry apply(String s) {
                SimpleRepoInterfaceEntry iface = new SimpleRepoInterfaceEntry();
                try {
                    Document doc = reader.read((Reader)new StringReader(s));
                    String country = doc.valueOf("//REPO/@country");
                    iface.setRepoId(doc.valueOf("//REPO/@id"));
                    iface.setRepoCountry(StringUtils.isEmpty((String)country) ? "-" : country.toUpperCase());
                    iface.setRepoName(doc.valueOf("//REPO/@name"));
                    iface.setRepoPrefix(doc.valueOf("//REPO/@prefix"));
                    Node ifcNode = doc.selectSingleNode("//INTERFACE");
                    iface.setId(ifcNode.valueOf("./@id"));
                    iface.setActive(Boolean.valueOf(ifcNode.valueOf("./@active")));
                    iface.setProtocol(ifcNode.valueOf("./ACCESS_PROTOCOL/text()"));
                    String overCompliance = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='overriding_compliance']");
                    if (StringUtils.isEmpty((String)overCompliance)) {
                        iface.setCompliance(ifcNode.valueOf("@compliance"));
                    } else {
                        iface.setCompliance(overCompliance);
                    }
                    String lastAggregationDate = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='last_aggregation_date']");
                    if (!StringUtils.isEmpty((String)lastAggregationDate)) {
                        iface.setAggrDate(lastAggregationDate);
                    } else {
                        String lastDownloadDate = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='last_download_date']");
                        if (!StringUtils.isEmpty((String)lastDownloadDate)) {
                            iface.setAggrDate(lastDownloadDate);
                        }
                    }
                    String lastAggregationTotal = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='last_aggregation_total']");
                    if (StringUtils.isEmpty((String)lastAggregationTotal)) {
                        String lastDownloadTotal = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='last_download_total']");
                        if (StringUtils.isEmpty((String)lastDownloadTotal)) {
                            iface.setAggrTotal(0);
                        } else {
                            iface.setAggrTotal(NumberUtils.toInt((String)lastDownloadTotal, (int)0));
                        }
                    } else {
                        iface.setAggrTotal(NumberUtils.toInt((String)lastAggregationTotal, (int)0));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                return iface;
            }
        });
        return list;
    }

    public RepoInterfaceEntry getApi(String repoId, String ifaceId) throws Exception {
        Node n;
        RepoInterfaceEntry ifc = new RepoInterfaceEntry();
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.getRepoApiQueryTmpl.getInputStream()));
        st.setAttribute("dsId", (Object)repoId);
        st.setAttribute("ifaceId", (Object)ifaceId);
        String query = st.toString();
        SAXReader reader = new SAXReader();
        String s = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
        Document doc = reader.read((Reader)new StringReader(s));
        ifc.setId(doc.valueOf("/api/id"));
        ifc.setLabel(doc.valueOf("/api/label"));
        ifc.setRepoId(doc.valueOf("/api/repo/@id"));
        ifc.setRepoName(doc.valueOf("/api/repo/text()"));
        ifc.setRepoCountry(doc.valueOf("/api/repo/@country"));
        ifc.setRepoPrefix(doc.valueOf("/api/repo/@prefix"));
        String protocol = doc.valueOf("/api/protocol");
        ifc.setProtocol(protocol);
        Set<String> toVerifyParams = this.getParameterNamesForProtocol(ifc.getProtocol());
        for (Object o : doc.selectNodes("/api/commonParams/param")) {
            n = (Node)o;
            ifc.getCommonParams().add(new SimpleParamEntry(n.valueOf("@name"), n.getText()));
        }
        log.debug((Object)("****** " + toVerifyParams));
        for (Object o : doc.selectNodes("/api/accessParams/param")) {
            n = (Node)o;
            String pname = n.valueOf("@name");
            if (toVerifyParams.contains(pname)) {
                ifc.getAccessParams().add(new SimpleParamEntry(pname, n.getText()));
                toVerifyParams.remove(pname);
                continue;
            }
            log.warn((Object)("Invalid param [" + pname + "] for protocol " + protocol + " in repo " + repoId));
        }
        for (String pname : toVerifyParams) {
            ifc.getAccessParams().add(new SimpleParamEntry(pname, ""));
            log.info((Object)("Adding missing param [" + pname + "] for protocol " + protocol + " in repo " + repoId));
        }
        for (Object o : doc.selectNodes("/api/extraFields/field")) {
            n = (Node)o;
            String name = n.valueOf("@name");
            String value = n.getText();
            if (name.equalsIgnoreCase("overriding_compliance")) {
                for (SimpleParamEntry e : ifc.getCommonParams()) {
                    if (!e.getName().equals("compliance")) continue;
                    e.setOtherValue(e.getValue());
                    e.setValue(value);
                }
                continue;
            }
            if (name.equalsIgnoreCase("last_aggregation_date")) {
                ifc.setAggrDate(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_aggregation_total")) {
                ifc.setAggrTotal(NumberUtils.toInt((String)value, (int)0));
                continue;
            }
            if (name.equalsIgnoreCase("last_aggregation_mdId")) {
                ifc.setAggrMdId(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_collection_date")) {
                ifc.setCollDate(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_collection_total")) {
                ifc.setCollTotal(NumberUtils.toInt((String)value, (int)0));
                continue;
            }
            if (name.equalsIgnoreCase("last_collection_mdId")) {
                ifc.setCollMdId(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_download_date")) {
                ifc.setDownloadDate(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_download_total")) {
                ifc.setDownloadTotal(NumberUtils.toInt((String)value, (int)0));
                continue;
            }
            if (name.equalsIgnoreCase("last_download_objId")) {
                ifc.setDownloadObjId(value);
                continue;
            }
            ifc.getOtherParams().add(new SimpleParamEntry(name, value));
        }
        for (Object o : doc.selectNodes("//metaWF")) {
            n = (Node)o;
            String id = n.valueOf("./id");
            String name = n.valueOf("./name");
            String status = n.valueOf("./status");
            String repoByeWfId = n.valueOf("./destroyWorkflow");
            int progress = 0;
            try {
                switch (WorkflowsConstants.WorkflowStatus.valueOf((String)status)) {
                    case MISSING: {
                        progress = 0;
                        break;
                    }
                    case ASSIGNED: {
                        progress = 25;
                        break;
                    }
                    case WAIT_SYS_SETTINGS: {
                        progress = 50;
                        break;
                    }
                    case WAIT_USER_SETTINGS: {
                        progress = 75;
                        break;
                    }
                    case EXECUTABLE: {
                        progress = 100;
                    }
                }
            }
            catch (Exception e) {
                progress = 0;
            }
            ifc.getMetaWFs().add(new RepoMetaWfEntry(id, name, status, repoByeWfId, progress));
        }
        return ifc;
    }

    public List<RepoEntry> listRepositories(String type) throws Exception {
        ArrayList list = Lists.newArrayList();
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.findReposQueryTmpl.getInputStream()));
        st.setAttribute("type", (Object)type);
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(st.toString())) {
            RepoEntry r = new RepoEntry();
            String[] arr = s.split("@=@");
            r.setId(arr[0].trim());
            r.setName(arr[1].trim());
            r.setOrigId(arr[2].trim());
            r.setApis(Sets.newHashSet((Object[])arr[3].replaceAll("\\s", "").split(",")));
            r.setValid("true".equals(arr[4].trim()));
            r.setTypology(type);
            list.add(r);
        }
        Collections.sort(list);
        return list;
    }

    public List<RepoMapEntry> listRepositories_asMap() throws Exception {
        final SAXReader reader = new SAXReader();
        String query = IOUtils.toString((InputStream)this.findReposMapQuery.getInputStream());
        List list = Lists.transform((List)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query), (Function)new Function<String, RepoMapEntry>(){

            public RepoMapEntry apply(String s) {
                RepoMapEntry r = new RepoMapEntry();
                try {
                    Document doc = reader.read((Reader)new StringReader(s));
                    r.setId(doc.valueOf("//dsId"));
                    r.setName(doc.valueOf("//name"));
                    r.setTot(Integer.parseInt(doc.valueOf("//size")));
                    r.setLat(Float.parseFloat(doc.valueOf("//lat")));
                    r.setLng(Float.parseFloat(doc.valueOf("//lng")));
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                return r;
            }
        });
        return list;
    }

    private String findLabel(String id, Map<String, String> vocabulary) {
        if (vocabulary.containsKey(id)) {
            return vocabulary.get(id);
        }
        return id;
    }

    private Map<String, String> getVocabulary(String vocabulary) throws ISLookUpException {
        String query = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code = '" + vocabulary + "']//TERM return concat($x/@code, ' @-@-@ ', $x/@english_name)";
        HashMap map = Maps.newHashMap();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query)) {
            String[] arr = s.split("@-@-@");
            map.put(arr[0].trim(), arr[1].trim());
        }
        return map;
    }

    private Set<String> getParameterNamesForProtocol(String protocol) {
        if (this.parametersMap.isEmpty()) {
            for (ProtocolDescriptor d : ((CollectorService)this.serviceLocator.getService(CollectorService.class)).listProtocols()) {
                this.parametersMap.put(d.getName().toLowerCase(), d.getParams());
            }
        }
        HashSet res = Sets.newHashSet();
        if (this.parametersMap.containsKey(protocol.toLowerCase())) {
            res.add("baseUrl");
            for (ProtocolParameter p : this.parametersMap.get(protocol.toLowerCase())) {
                res.add(p.getName());
            }
        }
        return res;
    }

    public String getBrowseFieldsJson() {
        return this.browseFieldsJson;
    }

    @Required
    public void setBrowseFieldsJson(String browseFieldsJson) {
        this.browseFieldsJson = browseFieldsJson;
    }
}

