/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.ProtocolParameterValue;
import eu.dnetlib.datasource.common.utils.DatasourceUpdater;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.repositories.RepoUIUtils;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoInterfaceEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoMapEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.SimpleParamEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.SimpleRepoInterfaceEntry;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.sarasvati.loader.WorkflowExecutor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RepoInternalController {
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource(name="datasourceUpdater")
    private DatasourceUpdater datasourceUpdater;
    @Resource
    private WorkflowSectionGrouper workflowSectionGrouper;
    @Resource
    private WorkflowExecutor workflowExecutor;
    @Resource
    private RepoUIUtils repoUIUtils;
    @Resource(name="repoUIJsonCache")
    private Cache repoUIJsonCache;
    private static final Log log = LogFactory.getLog(RepoInternalController.class);

    @RequestMapping(value={"/ui/browseRepoField.do"})
    @ResponseBody
    public List<SimpleParamEntry> browseRepoField(@RequestParam(value="xpath", required=true) String xpath, @RequestParam(value="vocabulary", required=true) String vocabulary) throws Exception {
        return this.repoUIUtils.browseRepoField(xpath, vocabulary);
    }

    @RequestMapping(value={"/ui/listApis.do"})
    @ResponseBody
    public List<SimpleRepoInterfaceEntry> listApis(@RequestParam(value="param", required=true) String param, @RequestParam(value="value", required=true) String value, @RequestParam(value="xpath", required=true) String xpath, @RequestParam(value="refresh", required=false) String refresh) throws Exception {
        String cacheKey = "list@@@" + param + "@@@" + value;
        Element elem = this.repoUIJsonCache.get((Serializable)((Object)cacheKey));
        if (elem != null && refresh == null) {
            return (List)elem.getObjectValue();
        }
        log.info((Object)("Refreshing " + cacheKey + " cache..."));
        List<SimpleRepoInterfaceEntry> list = this.repoUIUtils.listApis(param, value, xpath);
        this.repoUIJsonCache.put(new Element((Object)cacheKey, list));
        return list;
    }

    @RequestMapping(value={"/ui/listRepositories.map"})
    @ResponseBody
    public List<RepoMapEntry> listRepositories_asMap() throws Exception {
        return this.repoUIUtils.listRepositories_asMap();
    }

    @RequestMapping(value={"/ui/listRepositories.json"})
    @ResponseBody
    public List<RepoEntry> listRepositories(@RequestParam(value="type", required=true) String type) throws Exception {
        return this.repoUIUtils.listRepositories(type);
    }

    @RequestMapping(value={"/ui/validateRepo.do"})
    @ResponseBody
    public String listRepositories(@RequestParam(value="id", required=true) String id, @RequestParam(value="b", required=true) boolean b) throws Exception {
        String query = "count(/*[.//RESOURCE_TYPE/@value='MetaWorkflowDSResourceType' and .//DATAPROVIDER/@id='" + id + "'])";
        if (!b && Integer.parseInt(((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query)) > 0) {
            throw new Exception("Repo " + id + " can be invalidated: it is related to some metawfs");
        }
        String newId = b ? ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).validateProfile(id) : ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).invalidateProfile(id);
        this.repoUIJsonCache.removeAll();
        return newId;
    }

    @RequestMapping(value={"/ui/getRepoDetails.do"})
    public void getRepoDetails(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(id);
        ApplyXslt xslt = new ApplyXslt(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/functionality/modular/ui/repositories/xslt/repoDetails.xslt")));
        IOUtils.copy((Reader)new StringReader(xslt.evaluate((Object)profile)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/repoMetaWf.new"})
    @ResponseBody
    public String newDataProviderWorkflow(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="name", required=true) String repoName, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="wf", required=true) String wfId) throws Exception {
        HashMap params = Maps.newHashMap();
        params.put("dataprovider:id", repoId);
        params.put("dataprovider:name", repoName);
        params.put("dataprovider:interface", ifaceId);
        return this.workflowExecutor.startProcess(wfId, (Map)params);
    }

    @RequestMapping(value={"/ui/repoMetaWf.destroy"})
    @ResponseBody
    public String destroyDataProviderWorkflow(@RequestParam(value="destroyWf", required=true) String destroyWfId) throws Exception {
        return this.workflowExecutor.startProcess(destroyWfId, null);
    }

    @RequestMapping(value={"/ui/repoApi.get"})
    @ResponseBody
    public RepoInterfaceEntry getRepoApi(@RequestParam(value="repoId", required=true) String repoId, @RequestParam(value="ifaceId", required=true) String ifaceId) throws Exception {
        return this.repoUIUtils.getApi(repoId, ifaceId);
    }

    @RequestMapping(value={"/ui/repoApi.update"})
    @ResponseBody
    public boolean updateRepoApi(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="accessParams", required=true) String accessParamsJson) throws Exception {
        if (!StringUtils.isEmpty((String)accessParamsJson)) {
            this.datasourceUpdater.updateApiAccessParams(repoId, ifaceId, (Map)new Gson().fromJson(accessParamsJson, Map.class));
        }
        return true;
    }

    @RequestMapping(value={"/ui/repoApiCompliance.update"})
    @ResponseBody
    public boolean updateRepoApiCompliance(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="compliance", required=true) String compliance) throws Exception {
        log.debug((Object)("SET COMPLIANCE TO " + compliance));
        this.datasourceUpdater.overrideCompliance(repoId, ifaceId, compliance);
        this.repoUIJsonCache.removeAll();
        return true;
    }

    @RequestMapping(value={"/ui/repoApiCompliance.reset"})
    @ResponseBody
    public boolean resetRepoApiCompliance(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId) throws Exception {
        log.debug((Object)"RESET COMPLIANCE");
        this.datasourceUpdater.overrideCompliance(repoId, ifaceId, null);
        this.repoUIJsonCache.removeAll();
        return true;
    }

    @RequestMapping(value={"/ui/repos/repoApi.html"})
    public void resetRepoApiCompliance(ModelMap map) throws Exception {
    }

    @RequestMapping(value={"/ui/repoApi.new"})
    @ResponseBody
    public boolean addRepoApi(@RequestParam(value="repoId", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceJson) throws DatasourceManagerServiceException {
        IfaceDesc iface = (IfaceDesc)new Gson().fromJson(ifaceJson, IfaceDesc.class);
        log.info((Object)("Adding interface " + iface.getId() + " to repository " + repoId));
        DatasourceManagerService dsManager = (DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class);
        return dsManager.addInterface(repoId, iface);
    }

    @RequestMapping(value={"/ui/listValidValuesForParam.do"})
    @ResponseBody
    public List<ProtocolParameterValue> listValidValuesForParam(@RequestParam(value="protocol", required=true) String protocol, @RequestParam(value="param", required=true) String param, @RequestParam(value="baseUrl", required=true) String baseUrl) throws CollectorServiceException {
        return ((CollectorService)this.serviceLocator.getService(CollectorService.class)).listValidValuesForParam(protocol, baseUrl, param, null);
    }
}

