/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.repositories.objects.VocabularyEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ui.ModelMap;

public class RepoEnablerEntryPointController
extends ModuleEntryPoint {
    private String datasourceTypeVocabulary;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected void initialize(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        map.addAttribute("types", (Object)new Gson().toJson(this.listDatasourceTypes()));
    }

    private List<VocabularyEntry> listDatasourceTypes() throws ISLookUpException {
        String xquery = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code = '" + this.getDatasourceTypeVocabulary().trim() + "']//TERM return concat($x/@code, ' @@@ ', $x/@english_name)";
        ArrayList list = Lists.newArrayList();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery)) {
            String[] arr = s.split("@@@");
            list.add(new VocabularyEntry(arr[0].trim(), arr[1].trim()));
        }
        Collections.sort(list);
        return list;
    }

    public String getDatasourceTypeVocabulary() {
        return this.datasourceTypeVocabulary;
    }

    @Required
    public void setDatasourceTypeVocabulary(String datasourceTypeVocabulary) {
        this.datasourceTypeVocabulary = datasourceTypeVocabulary;
    }
}

