/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.repositories.RepoUIUtils;
import eu.dnetlib.functionality.modular.ui.repositories.objects.VocabularyEntry;
import eu.dnetlib.miscutils.collections.Pair;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ui.ModelMap;

public class RepoApisEntryPointController
extends ModuleEntryPoint {
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private RepoUIUtils repoUIUtils;
    private String compatibilityLevelsVocabulary;

    private RepoHIWorkflow parseQuery(String input) {
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((Reader)new StringReader(input));
            Element rootNode = doc.getRootElement();
            Node node = doc.selectSingleNode("//id");
            String id = node.getText();
            node = doc.selectSingleNode("//name");
            String name = node != null ? node.getText() : "";
            node = doc.selectSingleNode("//types");
            String type = node != null ? node.getText() : "";
            HashSet ifcTypes = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)type));
            node = doc.selectSingleNode("//compliances");
            String compliance = node != null ? node.getText() : "";
            HashSet compliances = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)compliance));
            List nodes = doc.selectNodes(".//FIELD");
            ArrayList<Pair<String, String>> fields = new ArrayList<Pair<String, String>>();
            if (nodes != null) {
                for (Node currentNode : nodes) {
                    String key = currentNode.valueOf("@name");
                    String value = currentNode.getText();
                    fields.add((Pair<String, String>)new Pair((Object)key, (Object)value));
                }
            }
            return new RepoHIWorkflow(id, name, ifcTypes, compliances, fields);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<RepoHIWorkflow> listRepoHIWorkflows() throws ISLookUpException {
        String xquery = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return <result> <id>{$x//RESOURCE_IDENTIFIER/@value/string()}</id> <name>{$x//WORKFLOW_NAME/text()}</name> <types>{$x//PARAM[@name='expectedInterfaceTypologyPrefixes']/text()}</types> <compliances>{$x//PARAM[@name='expectedCompliancePrefixes']/text()}</compliances> {$x//FIELD} </result>";
        ArrayList list = Lists.newArrayList();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return <result> <id>{$x//RESOURCE_IDENTIFIER/@value/string()}</id> <name>{$x//WORKFLOW_NAME/text()}</name> <types>{$x//PARAM[@name='expectedInterfaceTypologyPrefixes']/text()}</types> <compliances>{$x//PARAM[@name='expectedCompliancePrefixes']/text()}</compliances> {$x//FIELD} </result>")) {
            RepoHIWorkflow repoHiInfo = this.parseQuery(s);
            if (repoHiInfo == null) continue;
            list.add(repoHiInfo);
        }
        Collections.sort(list);
        return list;
    }

    private List<VocabularyEntry> listCompatibilityLevels() throws ISLookUpException {
        String xquery = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code = '" + this.getCompatibilityLevelsVocabulary().trim() + "']//TERM return concat($x/@code, ' @@@ ', $x/@english_name)";
        ArrayList list = Lists.newArrayList();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery)) {
            String[] arr = s.split("@@@");
            list.add(new VocabularyEntry(arr[0].trim(), arr[1].trim()));
        }
        Collections.sort(list);
        return list;
    }

    protected void initialize(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        map.addAttribute("availableRepohiWfs", (Object)new Gson().toJson(this.listRepoHIWorkflows()));
        map.addAttribute("compatibilityLevels", (Object)new Gson().toJson(this.listCompatibilityLevels()));
        map.addAttribute("browseFields", (Object)this.repoUIUtils.getBrowseFieldsJson());
    }

    public String getCompatibilityLevelsVocabulary() {
        return this.compatibilityLevelsVocabulary;
    }

    @Required
    public void setCompatibilityLevelsVocabulary(String compatibilityLevelsVocabulary) {
        this.compatibilityLevelsVocabulary = compatibilityLevelsVocabulary;
    }

    public class RepoHIWorkflow
    implements Comparable<RepoHIWorkflow> {
        private String id;
        private String name;
        private Set<String> ifaceTypes;
        private Set<String> compliances;
        private List<Pair<String, String>> fields;

        public RepoHIWorkflow(String id, String name, Set<String> ifaceTypes, Set<String> compliances, List<Pair<String, String>> fields) {
            this.id = id;
            this.name = name;
            this.ifaceTypes = ifaceTypes;
            this.compliances = compliances;
            this.fields = fields;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getIfaceTypes() {
            return this.ifaceTypes;
        }

        public Set<String> getCompliances() {
            return this.compliances;
        }

        @Override
        public int compareTo(RepoHIWorkflow o) {
            return this.getName().compareTo(o.getName());
        }

        public List<Pair<String, String>> getFields() {
            return this.fields;
        }

        public void setFields(List<Pair<String, String>> fields) {
            this.fields = fields;
        }
    }
}

