var module = angular.module('addRepoApiUI', []);

module.directive('bsHasError', function() {
	return {
		restrict: "A",
		link: function(scope, element, attrs, ctrl) {
			element.toggleClass('has-feedback', true);
			var input = element.find('input[ng-model], select[ng-model]');
			if (input) {
				scope.$watch(function() {
					return input.hasClass('ng-invalid');
				}, function(isInvalid) {
					element.toggleClass('has-error', isInvalid);
					element.toggleClass('has-success', !isInvalid);
					var feedback = element.find('.form-control-feedback');
					if (feedback) {
						feedback.toggleClass('glyphicon-warning-sign', isInvalid);
						feedback.toggleClass('glyphicon-ok', !isInvalid);
					}
				});
			}
		}
	};
});

module.directive('ngApiIdField', function() {
	return {
		restrict: 'E',
		scope: {
			'label'     : '@',
			'prefix'    : '=',
			'selection' : '=',
			'exclusion' : '='
		},
		templateUrl: '../resources/html/addRepoApi/ngApiIdField.html',
		link: function(scope, element, attrs) {
			scope.suffix = '';
			scope.alert = '';
			scope.mypattern = new RegExp(scope.regex);
			scope.$watch('suffix', function() {
				if (!scope.suffix) return;
				var tmpId = scope.prefix + scope.suffix;
				if($.inArray(tmpId, scope.exclusion) == -1) {
					scope.selection = tmpId;
					scope.alert = ''; 
				} else {
					scope.selection = '';
					scope.alert = 'The id already exists';
					
				}
			});
		}
	}
});



module.directive('ngSelectVocabularyField', function() {
	return {
		restrict: 'E',
		scope: {
            'label'            : '@',
            'vocabulary'       : '=',
            'selection'        : '=',
            'contextualParams' : '='
		},
		templateUrl: '../resources/html/addRepoApi/ngSelectVocabularyField.html',
		link: function(scope, elem, attrs) {
			scope.selectId = 'select_' + scope.label.replace( /\s/g, "_").toLowerCase();
			scope.updateValue = function(f) {
				if (scope.contextualParams) {
					if (f.params) {
						scope.contextualParams = f.params;
					} else {
						scope.contextualParams = [];
					}
				}
			}
		}
	}
});

module.directive('ngSimpleEditField', function() {
	return {
		restrict: 'E',
		scope: {
            'label'     : '@',
            'required'  : '@',
            'regex'     : '@',
            'selection' : '='
		},
		templateUrl: '../resources/html/addRepoApi/ngSimpleEditField.html',
		link: function(scope, element, attrs) {
			scope.mypattern = new RegExp(scope.regex);
		}
	}
});

module.controller('addRepoApiCtrl', function ($scope, $http) {
	$scope.values = {
		'compliances'         : getCompliances(),
		'types'               : getTypes(),
		'contentDescriptions' : getContentDescriptions(),
		'protocols'           : getProtocols()
	}
	$scope.repo = {};
	$scope.currentParams = [];
	$scope.api = {
		accessParams : {}
	};
	
	
	$scope.searchDatasource = function(text) {
		$scope.repo = {
			'name' : text,
			'id'     : 'id1234',
			'prefix' : 'api::id_1234::',
			'apis'   : [ 'api::id_1234::test', 'api::id_1234::ftp', 'api::id_1234::oai' ]
		}
		$scope.api = {accessParams : {}};
	}
	
	$scope.resetDatasource = function() {
		$scope.repo = {};
		$scope.api = {};
	}
	
	$scope.test = function(id) {
		alert(id);
	}
});