package eu.dnetlib.functionality.modular.ui.repositories;

import java.io.StringReader;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.google.common.collect.Maps;
import com.google.gson.Gson;

import eu.dnetlib.datasource.common.utils.DatasourceUpdater;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoInterfaceEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoMapEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.SimpleParamEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.SimpleRepoInterfaceEntry;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.sarasvati.loader.WorkflowExecutor;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

@Controller
public class RepoInternalController {

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Resource(name = "datasourceUpdater")
	private DatasourceUpdater datasourceUpdater;

	@Resource
	private WorkflowSectionGrouper workflowSectionGrouper;

	@Resource
	private WorkflowExecutor workflowExecutor;

	@Resource
	private RepoUIUtils repoUIUtils;

	@Resource(name = "repoUIJsonCache")
	private Cache repoUIJsonCache;

	private static final Log log = LogFactory.getLog(RepoInternalController.class);

	@RequestMapping(value = "/ui/browseRepoField.do")
	public @ResponseBody
	List<SimpleParamEntry> browseRepoField(@RequestParam(value = "xpath", required = true) final String xpath,
			@RequestParam(value = "vocabulary", required = true) final String vocabulary) throws Exception {
		return repoUIUtils.browseRepoField(xpath, vocabulary);
	}

	@SuppressWarnings("unchecked")
	@RequestMapping(value = "/ui/listApis.do")
	public @ResponseBody
	List<SimpleRepoInterfaceEntry> listApis(
			@RequestParam(value = "param", required = true) final String param,
			@RequestParam(value = "value", required = true) final String value,
			@RequestParam(value = "xpath", required = true) final String xpath,
			@RequestParam(value = "refresh", required = false) final String refresh) throws Exception {

		final String cacheKey = "list@@@" + param + "@@@" + value;

		final Element elem = repoUIJsonCache.get(cacheKey);

		if (elem != null && refresh == null) {
			return (List<SimpleRepoInterfaceEntry>) elem.getObjectValue();
		} else {
			log.info("Refreshing " + cacheKey + " cache...");
			final List<SimpleRepoInterfaceEntry> list = repoUIUtils.listApis(param, value, xpath);
			repoUIJsonCache.put(new Element(cacheKey, list));
			return list;
		}
	}

	@RequestMapping(value = "/ui/listRepositories.map")
	public @ResponseBody
	List<RepoMapEntry> listRepositories_asMap() throws Exception {
		return repoUIUtils.listRepositories_asMap();
	}

	@RequestMapping(value = "/ui/listRepositories.json")
	public @ResponseBody
	List<RepoEntry> listRepositories(@RequestParam(value = "type", required = true) final String type) throws Exception {
		return repoUIUtils.listRepositories(type);
	}

	@RequestMapping(value = "/ui/validateRepo.do")
	public @ResponseBody
	String listRepositories(@RequestParam(value = "id", required = true) final String id,
			@RequestParam(value = "b", required = true) final boolean b) throws Exception {

		final String query = "count(/*[.//RESOURCE_TYPE/@value='MetaWorkflowDSResourceType' and .//DATAPROVIDER/@id='" + id + "'])";
		if (!b && Integer.parseInt(serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query)) > 0) { throw new Exception("Repo " + id
				+ " can be invalidated: it is related to some metawfs"); }

		final String newId = b ?
				serviceLocator.getService(ISRegistryService.class).validateProfile(id) :
				serviceLocator.getService(ISRegistryService.class).invalidateProfile(id);

		repoUIJsonCache.removeAll();

		return newId;
	}

	@RequestMapping(value = "/ui/getRepoDetails.do")
	public void getRepoDetails(final HttpServletResponse response, @RequestParam(value = "id", required = true) final String id) throws Exception {
		final String profile = serviceLocator.getService(ISLookUpService.class).getResourceProfile(id);

		final ApplyXslt xslt = new ApplyXslt(IOUtils.toString(getClass().getResourceAsStream(
				"/eu/dnetlib/functionality/modular/ui/repositories/xslt/repoDetails.xslt")));

		IOUtils.copy(new StringReader(xslt.evaluate(profile)), response.getOutputStream());
	}

	@RequestMapping("/ui/repoMetaWf.new")
	public @ResponseBody
	String newDataProviderWorkflow(@RequestParam(value = "id", required = true) final String repoId,
			@RequestParam(value = "name", required = true) final String repoName,
			@RequestParam(value = "iface", required = true) final String ifaceId,
			@RequestParam(value = "wf", required = true) final String wfId) throws Exception {

		final Map<String, Object> params = Maps.newHashMap();
		params.put(WorkflowsConstants.DATAPROVIDER_ID, repoId);
		params.put(WorkflowsConstants.DATAPROVIDER_NAME, repoName);
		params.put(WorkflowsConstants.DATAPROVIDER_INTERFACE, ifaceId);

		return workflowExecutor.startProcess(wfId, params);
	}

	@RequestMapping("/ui/repoMetaWf.destroy")
	public @ResponseBody
	String destroyDataProviderWorkflow(@RequestParam(value = "destroyWf", required = true) final String destroyWfId)
			throws Exception {
		return workflowExecutor.startProcess(destroyWfId, null);
	}

	@RequestMapping("/ui/repoApi.get")
	public @ResponseBody
	RepoInterfaceEntry getRepoApi(@RequestParam(value = "repoId", required = true) final String repoId,
			@RequestParam(value = "ifaceId", required = true) final String ifaceId) throws Exception {
		return repoUIUtils.getApi(repoId, ifaceId);
	}

	@SuppressWarnings("unchecked")
	@RequestMapping("/ui/repoApi.update")
	public @ResponseBody
	boolean updateRepoApi(
			@RequestParam(value = "id", required = true) final String repoId,
			@RequestParam(value = "iface", required = true) final String ifaceId,
			@RequestParam(value = "accessParams", required = true) final String accessParamsJson) throws Exception {
		if (!StringUtils.isEmpty(accessParamsJson)) {
			datasourceUpdater.updateApiAccessParams(repoId, ifaceId, new Gson().fromJson(accessParamsJson, Map.class));
		}
		return true;
	}

	@RequestMapping("/ui/repoApiCompliance.update")
	public @ResponseBody
	boolean updateRepoApiCompliance(@RequestParam(value = "id", required = true) final String repoId,
			@RequestParam(value = "iface", required = true) final String ifaceId,
			@RequestParam(value = "compliance", required = true) final String compliance) throws Exception {

		log.debug("SET COMPLIANCE TO " + compliance);

		datasourceUpdater.overrideCompliance(repoId, ifaceId, compliance);

		repoUIJsonCache.removeAll();

		return true;
	}

	@RequestMapping("/ui/repoApiCompliance.reset")
	public @ResponseBody
	boolean resetRepoApiCompliance(@RequestParam(value = "id", required = true) final String repoId,
			@RequestParam(value = "iface", required = true) final String ifaceId) throws Exception {

		log.debug("RESET COMPLIANCE");

		datasourceUpdater.overrideCompliance(repoId, ifaceId, null);

		repoUIJsonCache.removeAll();

		return true;
	}

	@RequestMapping("/ui/repos/repoApi.html")
	public void resetRepoApiCompliance(final ModelMap map) throws Exception {}

	@RequestMapping("/ui/repoApi.new")
	public @ResponseBody
	boolean addRepoApi(@RequestParam(value = "repoId", required = true) final String repoId,
			@RequestParam(value = "iface", required = true) final IfaceDesc iface) throws DatasourceManagerServiceException {
		final DatasourceManagerService dsManager = serviceLocator.getService(DatasourceManagerService.class);
		return dsManager.addInterface(repoId, iface);
	}
}
