package eu.dnetlib.data.objectstore.modular.connector;

import java.util.List;

/**
 * The Interface ObjectStoreDao.
 */
public interface ObjectStoreDao {

	/**
	 * Gets an Object Store with the given identifier.
	 * <p>
	 * If an Object Store with the given identifier does not exist, a new one is created.
	 * </p>
	 * 
	 * @param obsId
	 *            the object store identifier
	 * @return the object store
	 */
	ObjectStore getObjectStore(String obsId);

	/**
	 * List all the Object stores.
	 * 
	 * @return the list of object store ids
	 */
	List<String> listObjectStores();

	/**
	 * Creates an Object Store with the given identifier.
	 * <p>
	 * If an Object Store with the given identifier already exists this method does nothing.
	 * </p>
	 * 
	 * @param obsId
	 *            the object store identifier
	 * @param interpretation
	 *            the interpretation of the store
	 * @return true, if successful
	 */
	boolean createObjectStore(String obsId, String interpretation);

	/**
	 * Upddate an Object Store metadata with the given identifier.
	 * <p>
	 * If an Object Store with the given identifier does not exist, a new one is created.
	 * </p>
	 * 
	 * @param obsId
	 *            the object store identifier
	 * @param interpretation
	 *            the interpretation of the store
	 * @return true, if successful
	 */
	boolean updateObjectStore(String obsId, String interpretation);

	/**
	 * Delete object store.
	 * 
	 * @param obsId
	 *            the object store identifier
	 * @return true, if successful
	 */
	boolean deleteObjectStore(String obsId);

}
