package eu.dnetlib.data.objectstore.modular;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

/**
 * The Class CreateObjectStoreAction is responsible to execute the blacboard action of type CREATE.
 */
public class CreateObjectStoreAction extends AbstractObjectStoreAction
		implements BlackboardServerAction<ObjectStoreActions> {

	/** The profile creator. */
	private ObjectStoreProfileCreator profileCreator;

	/* (non-Javadoc)
	 * @see eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction#execute(eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler, eu.dnetlib.enabling.tools.blackboard.BlackboardJob)
	 */
	@Override
	public void execute(BlackboardServerHandler handler, BlackboardJob job)
			throws Exception {

		final String interpretation = job.getParameters().get("interpretation");

		final String objID = profileCreator.registerProfile(interpretation);

		getDao().createObjectStore(objID, interpretation);

		job.getParameters().put("objectStoreId", objID);

		handler.done(job);

	}

	/**
	 * Gets the profile creator.
	 *
	 * @return the profile creator
	 */
	public ObjectStoreProfileCreator getProfileCreator() {
		return profileCreator;
	}

	/**
	 * Sets the profile creator.
	 *
	 * @param profileCreator the new profile creator
	 */
	public void setProfileCreator(ObjectStoreProfileCreator profileCreator) {
		this.profileCreator = profileCreator;
	}

}
