package eu.dnetlib.data.objectstore.modular;

import java.io.IOException;
import java.io.InputStream;

import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;

// TODO: Auto-generated Javadoc
/**
 * The Class ModularObjectStoreRESTService implement the controller REST of the object Store.
 */
@Controller
public class ModularObjectStoreRESTService {

	/** The object store deliver. */
	@Resource
	ModularObjectStoreDeliver objectStoreDeliver;

	/**
	 * Retrieve.
	 *
	 * @param res
	 *            the res
	 * @param objectStoreId
	 *            the object store id
	 * @param objectId
	 *            the object id
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 * @throws ObjectStoreServiceException
	 */
	@RequestMapping(value = "/**/objectStore/retrieve.do")
	public void retrieve(final HttpServletResponse res,
			@RequestParam(value = "objectStore", required = true) final String objectStoreId,
			@RequestParam(value = "objectId", required = true) final String objectId) throws IOException, ObjectStoreServiceException {

		ObjectStoreFile file = objectStoreDeliver.deliverObject(objectStoreId, objectId);

		if (file == null) throw new RuntimeException("The file with id " + objectId + " doesn't exist");

		// res.setContentType(file.getMimeType());

		InputStream is = objectStoreDeliver.deliverStream(objectStoreId, objectId);

		ServletOutputStream outputStream = res.getOutputStream();

		IOUtils.copy(is, outputStream);

		/*
		 * while (true) { int readSize = is.read(buffer); if (readSize == -1) { break; } outputStream.write(buffer, 0, readSize); }
		 */
	}
}
