package eu.dnetlib.data.objectstore.modular;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

// TODO: Auto-generated Javadoc
/**
 * The Class FeedCompleteObjectAction is responsible to execute the blacboard action of type FEED OBJECT which is Metadata created for WOS case of openaire.
 */
public class FeedCompleteObjectAction extends AbstractObjectStoreAction implements BlackboardServerAction<ObjectStoreActions> {

	/** The store feeder. */
	private ModularObjectStoreFeeder storeFeeder;

	/* (non-Javadoc)
	 * @see eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction#execute(eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler, eu.dnetlib.enabling.tools.blackboard.BlackboardJob)
	 */
	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		final String objStoreID = job.getParameters().get("obsID");
		final String eprRs = job.getParameters().get("epr");
		final String mime = job.getParameters().get("mime");
		storeFeeder.feedMetadataObjectRecord(objStoreID, eprRs, mime);
		handler.done(job);
	}

	/**
	 * Gets the store feeder.
	 *
	 * @return the store feeder
	 */
	public ModularObjectStoreFeeder getStoreFeeder() {
		return storeFeeder;
	}

	/**
	 * Sets the store feeder.
	 *
	 * @param storeFeeder the new store feeder
	 */
	@Required
	public void setStoreFeeder(final ModularObjectStoreFeeder storeFeeder) {
		this.storeFeeder = storeFeeder;
	}

}
