package eu.dnetlib.data.objectstore.modular;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

/**
 * The Class DeleteObjectStoreAction is responsible to execute the blacboard action of type DELETE.
 */
public class DeleteObjectStoreAction extends AbstractObjectStoreAction
		implements BlackboardServerAction<ObjectStoreActions> {

	/** The profile creator. */
	private ObjectStoreProfileCreator profileCreator;

	/* (non-Javadoc)
	 * @see eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction#execute(eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler, eu.dnetlib.enabling.tools.blackboard.BlackboardJob)
	 */
	@Override
	public void execute(BlackboardServerHandler handler, BlackboardJob job)
			throws Exception {

		final String objID = job.getParameters().get("obsID");

		getDao().deleteObjectStore(objID);
		handler.done(job);

	}

	/**
	 * Gets the profile creator.
	 *
	 * @return the profile creator
	 */
	public ObjectStoreProfileCreator getProfileCreator() {
		return profileCreator;
	}

	/**
	 * Sets the profile creator.
	 *
	 * @param profileCreator the new profile creator
	 */
	public void setProfileCreator(ObjectStoreProfileCreator profileCreator) {
		this.profileCreator = profileCreator;
	}

}
