/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.lightui.objects;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.functionality.index.client.response.BrowseEntry;
import eu.dnetlib.functionality.index.client.response.BrowseValueEntry;
import eu.dnetlib.functionality.modular.ui.lightui.LightUIUtils;
import eu.dnetlib.functionality.modular.ui.lightui.clients.ISLookupClient;
import eu.dnetlib.functionality.modular.ui.lightui.clients.IndexLightUIClient;
import eu.dnetlib.functionality.modular.ui.lightui.objects.IndexConfiguration;
import eu.dnetlib.functionality.modular.ui.lightui.objects.SearchField;
import eu.dnetlib.functionality.modular.ui.lightui.objects.ValueWithLabel;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class SearchFieldGrouper {
    private static final int maxBrowseValues = 100;
    @Resource
    private IndexLightUIClient indexClient;
    @Resource
    private ISLookupClient isLookupClient;
    @Resource
    private LightUIUtils lightUiUtils;
    private static final Log log = LogFactory.getLog(SearchFieldGrouper.class);

    public List<SearchField> getAllFields(String lightuiId) {
        ArrayList res = Lists.newArrayList();
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((Reader)new StringReader(this.isLookupClient.getLightUiProfile(lightuiId)));
            Node searchNode = doc.selectSingleNode("//CONFIGURATION/SEARCH");
            IndexConfiguration idx = this.getIndexConfiguration(searchNode);
            res.addAll(this.getPredefinedFields(searchNode));
            res.addAll(this.calculateBrowseFields(idx, searchNode));
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining search fields", (Throwable)e);
        }
        return res;
    }

    private IndexConfiguration getIndexConfiguration(Node searchNode) {
        String id = searchNode.valueOf("./INDEX/@id");
        String format = searchNode.valueOf("./INDEX/@format");
        String layout = searchNode.valueOf("./INDEX/@layout");
        String interpretation = searchNode.valueOf("./INDEX/@interpretation");
        String backendId = searchNode.valueOf("./INDEX/@backendId");
        return new IndexConfiguration(id, format, layout, interpretation, backendId);
    }

    private List<SearchField> calculateBrowseFields(IndexConfiguration idx, Node node) {
        try {
            return Lists.transform(this.indexClient.browse("*=*", idx, this.lightUiUtils.getBrowseFields(node), 100), (Function)new Function<BrowseEntry, SearchField>(){

                public SearchField apply(BrowseEntry r) {
                    SearchField sf = new SearchField();
                    sf.setField(r.getField());
                    sf.setLabel(r.getLabel());
                    sf.setOperator("exact");
                    sf.setPredefinedValues(Lists.transform((List)r.getValues(), (Function)new Function<BrowseValueEntry, ValueWithLabel>(){

                        public ValueWithLabel apply(BrowseValueEntry bv) {
                            return new ValueWithLabel(bv.getValue() + " (" + bv.getSize() + ")", bv.getValue());
                        }
                    }));
                    return sf;
                }
            });
        }
        catch (Exception e) {
            log.warn((Object)"Error executing default browse query", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    private List<SearchField> getPredefinedFields(Node node) {
        String operator;
        String label;
        String id;
        ArrayList list = Lists.newArrayList();
        for (Object o : node.selectNodes(".//TEXT_FIELD")) {
            id = ((Element)o).valueOf("@id");
            label = ((Element)o).valueOf("@label");
            operator = ((Element)o).valueOf("@operator");
            list.add(new SearchField(id, label, operator));
        }
        for (Object o : node.selectNodes(".//SELECT_FIELD")) {
            id = ((Element)o).valueOf("@id");
            label = ((Element)o).valueOf("@label");
            operator = ((Element)o).valueOf("@operator");
            ArrayList values = Lists.newArrayList();
            for (Object v : ((Element)o).selectNodes("./VALUE")) {
                String v_id = ((Element)v).valueOf("@id");
                String v_label = ((Element)v).valueOf("@label");
                values.add(new ValueWithLabel(v_label, v_id));
            }
            list.add(new SearchField(id, label, operator, values));
        }
        return list;
    }
}

