var module = angular.module('lightUI', ['ngRoute', 'lightUiControllers']);

module.config([
	'$routeProvider',
	function($routeProvider) {
		$routeProvider
           		.when('/form',                 { templateUrl: '../resources/html/lightUiForm.html',    controller: 'lightUiFormCtrl' })
           		.when('/results/:page/:query', { templateUrl: '../resources/html/lightUiResults.html', controller: 'lightUiResultsCtrl'   })
           		.when('/doc/:field/:id',       { templateUrl: '../resources/html/lightUiDoc.html',     controller: 'lightUiDocCtrl'    })
           		.otherwise({ redirectTo: '/form' });
	}
]);

module.directive('compileTemplate', function($compile, $parse){
	return {
		link: function(scope, element, attr){
			var parsed = $parse(attr.ngBindHtml);
            
			function getStringValue() { return (parsed(scope) || '').toString(); }

			//Recompile if the template changes
			scope.$watch(getStringValue, function() {
                $compile(element, null, -9999)(scope);  //The -9999 makes it skip directives so that we do not recompile ourselves
			});
		}
	}
});

module.service('sharedProperties', function () {
	var browseHtml = "";
	var totalPages = 0;
	var total =0;
	var query = "";
	
	return {
		getBrowseHtml: function ()     { return browseHtml; },
		setBrowseHtml: function (html) { browseHtml = html; },
		getQuery:      function ()     { return query;      },
		setQuery:      function (q)    { query = q;         },	
		getTotalPages: function ()     { return totalPages; },
		setTotalPages: function (n)    { totalPages = n;    },
		getTotal: 	   function ()     { return total; 		},
		setTotal: 	   function (n)    { total = n;    		}
	};
});
