package eu.dnetlib.functionality.index.utils;

import javax.xml.ws.Endpoint;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import eu.dnetlib.soap.EndpointReferenceBuilder;

public class ServiceAddressGetter implements ApplicationContextAware {

	private ApplicationContext applicationContext;

	private EndpointReferenceBuilder<Endpoint> eprBuilder;

	@Override
	public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {

		this.applicationContext = applicationContext;
	}

	public String getServiceAddress() {

		return getEprBuilder().getAddress(applicationContext.getBean("modularIndexServiceEndpoint", Endpoint.class));
	}

	@Required
	public void setEprBuilder(final EndpointReferenceBuilder<Endpoint> eprBuilder) {
		this.eprBuilder = eprBuilder;
	}

	public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
		return eprBuilder;
	}

}
