package eu.dnetlib.functionality.index.actors;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.functionality.index.action.BBParam;

public class ResultsetKeepAliveJob implements Job {

	private static final Log log = LogFactory.getLog(ResultsetKeepAliveJob.class); // NOPMD by marko on 11/24/08 5:02 PM

	public static final String JOB_NAME = "resultsetKeepaliveJob";

	public static final String JOB_GROUP = "keepalive";

	/**
	 * used to resolve the epr references to the service endpoint
	 */
	private ServiceResolver serviceResolver;

	private EPRUtils eprUtils;

	@Override
	public void execute(final JobExecutionContext context) throws JobExecutionException {

		final String rsEpr = (String) context.getTrigger().getJobDataMap().get(BBParam.RS_EPR);
		final W3CEndpointReference epr = eprUtils.getEpr(rsEpr);

		final ResultSetService resultSet = getServiceResolver().getService(ResultSetService.class, epr);
		final String rsId = serviceResolver.getResourceIdentifier(epr);

		try {
			log.debug("\n\n keepalive resultset: " + rsId + " triggerId: " + context.getTrigger().getName() + "\n\n");

			// TODO: change to a getRSStatus call, getNumberOfElements could be potentially slow (ticket #1569)
			resultSet.getNumberOfElements(rsId);
		} catch (ResultSetException e) {
			log.warn("couldn't invoke the resultset call to keep-it-alive");
			throw new RuntimeException(e);
		}
	}

	public void setServiceResolver(final ServiceResolver serviceResolver) {
		this.serviceResolver = serviceResolver;
	}

	public ServiceResolver getServiceResolver() {
		return serviceResolver;
	}

	public void setEprUtils(final EPRUtils eprUtils) {
		this.eprUtils = eprUtils;
	}

	public EPRUtils getEprUtils() {
		return eprUtils;
	}

}
