package eu.dnetlib.functionality.index.action;

import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.functionality.index.IndexModularService;

/**
 * The Class that implements Identify Action.
 */
public class IdentifyAction extends AbstractIndexAction implements BlackboardServerAction<IndexAction> {

	/** The index service. */
	@Autowired
	private IndexModularService indexService;

	/**
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction#execute(eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler,
	 *      eu.dnetlib.enabling.tools.blackboard.BlackboardJob)
	 */
	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		job.getParameters().put(BBParam.SERVICE_ID, indexService.identify());
	}

}
