package eu.dnetlib.functionality.index;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.provision.index.rmi.IndexService;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.functionality.index.utils.ServiceTools;

/**
 * The Class IndexModularService.
 */
public class IndexModularService extends AbstractBaseService implements IndexService {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(IndexService.class);

	/** The notification handler. */
	private NotificationHandler notificationHandler;

	/** The service tools. */
	@Autowired
	private ServiceTools serviceTools;

	/**
	 * {@inheritDoc}
	 *
	 * @see eu.dnetlib.common.rmi.BaseService#notify(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		log.debug("Notify method is called");
		getNotificationHandler().notified(subscriptionId, topic, isId, message);

	}

	/**
	 * {@inheritDoc}
	 *
	 * @see eu.dnetlib.common.rmi.BaseService#identify()
	 */
	@Override
	public String identify() {
		log.debug("Identify method is called");
		return this.getClass().toString();
	}

	/**
	 * {@inheritDoc}
	 *
	 * @throws IndexServiceException
	 *
	 * @see eu.dnetlib.data.provision.index.rmi.IndexService#getListOfIndices()
	 */
	@Override
	public List<String> getListOfIndices() throws IndexServiceException {

		return serviceTools.listDsIds();
	}

	/**
	 * Gets the notification handler.
	 *
	 * @return the notificationHandler
	 */
	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	/**
	 * Sets the notification handler.
	 *
	 * @param notificationHandler
	 *            the notificationHandler to set
	 */
	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

}
