var dbManagerControllers = angular.module('dbManagerControllers', []);

function common_init($scope, $http, $sce, $location) {
	initSpinner();
	$scope.showError        = function(error)   { show_notification("error", error); }
	$scope.showNotification = function(message) { show_notification("info", message); }
	$scope.showSpinner      = function()        { showSpinner(); }
	$scope.hideSpinner      = function()        { hideSpinner(); }
	$scope.to_trusted       = function(html)    { return $sce.trustAsHtml(html); }
	$scope.go               = function(path)    { $location.path(path); }
	$scope.encodeValue      = function(val)     { return val; }
}

dbManagerControllers.controller('databasesCtrl', [
	'$scope', '$http', '$sce', '$location', 
	function ($scope, $http, $sce, $location) {
		common_init($scope, $http, $sce, $location);
		
		$scope.databases = [];
		
		$scope.listDatabases = function() {
			$scope.databases = [];

			$scope.showSpinner();
			
			$http.get('listDBs.do').success(function(data) {
				$scope.hideSpinner();
				$scope.databases = data;
		    }).error(function() {
	            $scope.showError('Something really bad must have happened to our fellow hamster..');
	            $scope.hideSpinner();
		    });
		}
		
		$scope.manageDB = function(db, b) {
			$scope.showSpinner();
			
			$http.get('manageDB.do?db=' + db + "&manage=" + b).success(function(data) {
				$scope.hideSpinner();
				$scope.showNotification("Management Mode Updated !");
				$scope.listDatabases();
		    }).error(function() {
	            $scope.showError('Something really bad must have happened to our fellow hamster..');
	            $scope.hideSpinner();
		    });
		}
		
		$scope.changeIdentifiers = function(db) {
			if (confirm("Are you sure ?")) {
				$scope.showSpinner();
				
				$http.get('changeIdentifiers.do?db=' + db).success(function(data) {
					$scope.hideSpinner();
					$scope.showNotification("Identifiers changed !");
					$scope.listDatabases();
			    }).error(function() {
		            $scope.showError('Something really bad must have happened to our fellow hamster..');
		            $scope.hideSpinner();
			    });
			}
		}
			
		$scope.listDatabases();
	}
]);

dbManagerControllers.controller('tablesCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',  
    function ($scope, $http, $sce, $location, $routeParams) {
		common_init($scope, $http, $sce, $location);
		
		$scope.db       = $routeParams.db;
		$scope.dbtables = [];
		
		$scope.listTables = function() {
			$scope.dbtables = [];

			$scope.showSpinner();
			
			$http.get('listTables.do?db=' + $scope.db).success(function(data) {
				$scope.hideSpinner();
				$scope.dbtables = data;
		    }).error(function() {
	            $scope.showError('Something really bad must have happened to our fellow hamster..');
	            $scope.hideSpinner();
		    });
		}
		
		$scope.changeTableManagement = function(db, t) {
			$scope.showSpinner();
			
			$http.get('changeTableManagement.do?db=' + db + "&t=" + t).success(function(data) {
				$scope.hideSpinner();
				$scope.showNotification("Management Mode Updated !");
				$scope.listTables();
		    }).error(function() {
	            $scope.showError('Something really bad must have happened to our fellow hamster..');
	            $scope.hideSpinner();
		    });
		}
		
		$scope.changeTableLog = function(db, t) {
			$scope.showSpinner();
			
			$http.get('changeTableLog.do?db=' + db + "&t=" + t).success(function(data) {
				$scope.hideSpinner();
				$scope.showNotification("Log Mode Updated !");
				$scope.listTables();
		    }).error(function() {
	            $scope.showError('Something really bad must have happened to our fellow hamster..');
	            $scope.hideSpinner();
		    });
		}
		
		$scope.changeIdentifiers = function(db, t) {
			if (confirm("Are you sure ?")) {
				$scope.showSpinner();
				
				$http.get('changeIdentifiers.do?db=' + db + '&t=' + t).success(function(data) {
					$scope.hideSpinner();
					$scope.showNotification("Identifiers changed !");
					$scope.listDatabases();
			    }).error(function() {
		            $scope.showError('Something really bad must have happened to our fellow hamster..');
		            $scope.hideSpinner();
			    });
			}
		}
		
		$scope.listTables();
	}
]);

dbManagerControllers.controller('tableDescCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',  
	function ($scope, $http, $sce, $location, $routeParams) {
		common_init($scope, $http, $sce, $location);
		
		$scope.db       = $routeParams.db;
		$scope.table    = $routeParams.t;
		$scope.details  = [];
		
		$scope.getTableDetails = function() {
			$scope.details = [];

			$scope.showSpinner();
			
			$http.get('describeTable.do?db=' + $scope.db + "&t=" + $scope.table).success(function(data) {
				$scope.hideSpinner();
				$scope.details = data;
		    }).error(function() {
	            $scope.showError('Something really bad must have happened to our fellow hamster..');
	            $scope.hideSpinner();
		    });
		}
		
		$scope.getTableDetails();
	}

]);

dbManagerControllers.controller('dbQueryCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',  
	function ($scope, $http, $sce, $location, $routeParams) {
		common_init($scope, $http, $sce, $location);
                                            		
        $scope.db = $routeParams.db;
        $scope.sql = 'SELECT 1';
        $scope.limit = 100;
        $scope.results = [];
        
        $scope.searchSQL = function() {
			$scope.results = [];

			$scope.showSpinner();
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
            $http.post('query.do', $.param({
                    'db'    : $scope.db,
                    'limit' : $scope.limit,
                    'query' : $scope.sql
            })).success(function(data) {
				$scope.hideSpinner();
				$scope.results = data;
		    }).error(function() {
	            $scope.showError('Something really bad must have happened to our fellow hamster..');
	            $scope.hideSpinner();
		    });
		}
        
	}
]);