<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="setFormat"/>
	</ARCS>
</NODE>

<NODE name="setFormat" type="SetFormatInfo" isStart="true">
     <DESCRIPTION>Set Format Info</DESCRIPTION>
     <PARAMETERS>
         <PARAM managedBy="user" name="format" required="true" type="string">DMF</PARAM>
         <PARAM managedBy="user" name="layout" required="true" type="string">store</PARAM>
         <PARAM managedBy="user" name="interpretation" required="true" type="string">transformed</PARAM>
         <PARAM managedBy="system" name="formatParam" required="true" type="string">oai_format</PARAM>
         <PARAM managedBy="system" name="layoutParam" required="true" type="string">oai_layout</PARAM>
         <PARAM managedBy="system" name="interpretationParam" required="true" type="string">oai_interpretation</PARAM>
     </PARAMETERS>
     <ARCS>
         <ARC to="prepareOAI"/>
     </ARCS>
 </NODE>
 
 <NODE name="prepareOAI" type="PrepareOaiJob">
     <DESCRIPTION>Prepare oai feeding</DESCRIPTION>
     <PARAMETERS>
         <PARAM managedBy="system" name="oaiStoreCollectionParam" required="true" type="string">oaiStoreCollection</PARAM>
         <PARAM managedBy="user" name="oaiDBName" required="true" type="string">oaistore</PARAM>
         <PARAM managedBy="system" name="oaiDBNameParam" required="true" type="string">oai_dbName</PARAM>
     </PARAMETERS>
     <ARCS>
         <ARC to="CompoundIndexes"/>
     </ARCS>
 </NODE>
 
 <NODE name="CompoundIndexes" type="OAICreateIndex">
     <DESCRIPTION>Create composite indexes for the OAI store</DESCRIPTION>
     <PARAMETERS>
         <PARAM managedBy="system" name="dbNameParam" required="true" type="string">oai_dbName</PARAM>
         <PARAM managedBy="system" name="oaiStoreCollectionParam" required="true" type="string">oaiStoreCollection</PARAM>
         <PARAM managedBy="user" name="fieldNames" required="true" type="string">set,datestamp</PARAM>
     </PARAMETERS>
     <ARCS>
         <ARC to="ConfigIndexes"/>
     </ARCS>
 </NODE>
 
 <NODE name="ConfigIndexes" type="OAIEnsureIndexes">
     <DESCRIPTION>Ensure an index exists on fields as specified in the configuration profile</DESCRIPTION>
     <PARAMETERS>
         <PARAM managedBy="system" name="dbNameParam" required="true" type="string">oai_dbName</PARAM>
         <PARAM managedBy="system" name="oaiStoreCollectionParam" required="true" type="string">oaiStoreCollection</PARAM>
     </PARAMETERS>
     <ARCS>
         <ARC to="SetsCount"/>
     </ARCS>
 </NODE>
 
 <NODE name="SetsCount" type="OAISetsCountUpdate">
     <DESCRIPTION>Count records in each OAI set, for each exported metadata format linked to the given oai collection</DESCRIPTION>
     <PARAMETERS>
         <PARAM managedBy="system" name="dbNameParam" required="true" type="string">oai_dbName</PARAM>
         <PARAM managedBy="system" name="oaiStoreCollectionParam" required="true" type="string">oaiStoreCollection</PARAM>
         <PARAM managedBy="user" name="configuredOnly" required="true" type="boolean">false</PARAM>
     </PARAMETERS>
     <ARCS>
         <ARC to="ConfigSets"/>
     </ARCS>
 </NODE>
 
 <NODE name="ConfigSets" type="RefreshSetsFromConfig">
     <DESCRIPTION>Reads the current OAI configuration and upsert OAI sets accordingly (counts are updated as well)</DESCRIPTION>
     <PARAMETERS>
         <PARAM managedBy="system" name="dbNameParam" required="true" type="string">oai_dbName</PARAM>
     </PARAMETERS>
     <ARCS>
         <ARC to="success"/>
     </ARCS>
 </NODE>