package eu.dnetlib.data.mapreduce;

import java.util.List;

import javax.annotation.Resource;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;

import eu.dnetlib.data.hadoop.config.ClusterName;

public class JobClientResolver {

	@Resource
	private List<JobClient> clients;

	public JobClient getClient(ClusterName clusterName) {
		for (JobClient client : clients) {
			final Configuration conf = client.getConf();
			final ClusterName name = ClusterName.valueOf(conf.get("dnet.clustername"));
			if (name.equals(clusterName)) {
				return client;
			}
		}
		throw new IllegalArgumentException(clusterName.toString() + " not defined");
	}

}
