package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getKey;
import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getValue;
import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.listValues;

import org.dom4j.DocumentException;

import com.google.common.collect.Iterables;

import eu.dnetlib.broker.objects.Journal;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.broker.objects.Provenance;
import eu.dnetlib.broker.objects.Publication;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.Instance;

/**
 * Created by claudio on 11/07/16.
 */
public class OpenAireEventPayloadFactory extends ProtoMapping {

	public static OpenAireEventPayload fromOAF(final OafEntity oaf,
			final OafEntity source,
			final float trust) throws DocumentException {

		final Result.Metadata m = oaf.getResult().getMetadata();
		final Publication p = new Publication()
				.setOriginalId(getValue(oaf.getOriginalIdList()))
				.setTitles(listValues(m.getTitleList()))
				.setAbstracts(listValues(m.getDescriptionList()))
				.setLanguage(getKey(m.getLanguage()))
				.setSubjects(listValues(m.getSubjectList()))
				.setCreators(listValues(oaf.getResult().getAuthorList()))
				.setPublicationdate(getValue(m.getDateofacceptance()))
				.setPublisher(getValue(m.getPublisher()))
				.setEmbargoenddate(getValue(m.getEmbargoenddate()))
				.setContributor(listValues(m.getContributorList()))
				.setJournal(new Journal()
						.setName(m.getJournal().getName())
						.setIssn(m.getJournal().getIssnPrinted())
						.setEissn(m.getJournal().getIssnOnline())
						.setLissn(m.getJournal().getIssnLinking()))
				.setCollectedFrom(listValues(oaf.getCollectedfromList()))
				.setPids(mapPids(oaf.getPidList()))
				.setInstances(mapInstances(oaf.getResult().getInstanceList()))
				.setExternalReferences(mapExternalRefs(oaf.getResult().getExternalReferenceList()))
				.setProjects(mapRelatedProjects(oaf));

		final OpenAireEventPayload ep = new OpenAireEventPayload();

		final Instance instance = Iterables.getFirst(source.getResult().getInstanceList(), Instance.newBuilder().build());

		ep.setPublication(p).setHighlight(new Publication()).setProvenance(new Provenance().setRepositoryName(getValue(source.getCollectedfromList()))
				.setUrl(getValue(instance.getUrlList())).setId(getValue(source.getOriginalIdList()))).setTrust(trust);

		return ep;
	}

}
