package eu.dnetlib.data.mapreduce.hbase.broker;

import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PersonProtos;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

/**
 * Created by michele on 12/10/15.
 */
public class CalculatePersonDistributionUtils {

	public static final String SEPARATOR = "||@@||";
	private static final String PERSON_PREFIX = "PERSON" + SEPARATOR;
	private static final String DS_TYPE_PREFIX = "DSTYPE" + SEPARATOR;

	public static String createPersonValue(final PersonProtos.Person p) {
		try {
			final String fn = p.getMetadata().getFirstname().getValue();
			String sn = "";
			for (FieldTypeProtos.StringField sf : p.getMetadata().getSecondnamesList()) {
				sn += sf.getValue();
			}
			if (StringUtils.isNotBlank(fn) && StringUtils.isNotBlank(sn)) {
				return PERSON_PREFIX + sn + "_" + fn.substring(0, 1);
			}
			return null;
		} catch (Throwable e) {
			return null;
		}
	}

	public static String createDsTypeValue(final DatasourceProtos.Datasource ds) {
		return DS_TYPE_PREFIX + ds.getMetadata().getDatasourcetype().getClassid();
	}

	public static boolean isPerson(byte[] b) {
		return Bytes.toString(b).startsWith(PERSON_PREFIX);
	}

	public static boolean isDsType(byte[] b) {
		return Bytes.toString(b).startsWith(DS_TYPE_PREFIX);
	}

	public static String getPersonName(final byte[] b) {
		return StringUtils.substringAfter(Bytes.toString(b), PERSON_PREFIX);
	}

	public static String getType(final byte[] b) {
		return StringUtils.substringAfter(Bytes.toString(b), DS_TYPE_PREFIX);
	}

	public static Text prepareHdfsValue(String dsId, String name) {
		return new Text(dsId + CalculatePersonDistributionUtils.SEPARATOR + name);
	}

	public static Text prepareHdfsKey(final String dsId, final int count) {
		return new Text(dsId + "_" + count);
	}

	public static Text getDsIdFromHdfsValue(Text text) {
		return new Text(StringUtils.substringBefore(Bytes.toString(text.copyBytes()), SEPARATOR));
	}

	public static Text getNameFromHdfsValue(Text text) {
		return new Text(StringUtils.substringAfter(Bytes.toString(text.copyBytes()), SEPARATOR));
	}

}
