package eu.dnetlib.data.mapreduce.util;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;

import eu.dnetlib.data.proto.TypeProtos.Type;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class TemplateFactory {

	private static final Log log = LogFactory.getLog(TemplateFactory.class); // NOPMD by marko on 11/24/08 5:02 PM

	protected TemplateResources resources = new TemplateResources();

	public String buildBody(final Type type, final List<String> metadata, final List<String> rels, final List<String> children, final List<String> inference) {

		StringTemplate body = getTemplate(resources.getEntity());

		body.setAttribute("name", type.toString());
		body.setAttribute("metadata", metadata);
		body.setAttribute("rels", rels);
		body.setAttribute("children", children);
		body.setAttribute("inference", inference);

		return body.toString();
	}

	public String getChild(final String name, final String id, final List<String> metadata) {
		StringTemplate child = getTemplate(resources.getChild());

		child.setAttribute("name", name);
		child.setAttribute("hasId", !(id == null));
		child.setAttribute("id", id != null ? XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(id)) : "");
		child.setAttribute("metadata", metadata);

		String string = child.toString();
		return string;
	}

	public String buildRecord(final Type type,
			final String objIdentifier,
			final String dateOfCollection,
			final String dateOfTransformation,
			final String schemaLocation,
			final String body,
			final List<String> counters) {
		final StringTemplate recordTemplate = getTemplate(resources.getRecord());

		recordTemplate.setAttribute("id", XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(objIdentifier)));
		recordTemplate.setAttribute("dateofcollection", dateOfCollection);
		recordTemplate.setAttribute("dateoftransformation", dateOfTransformation);
		recordTemplate.setAttribute("schemaLocation", schemaLocation);
		recordTemplate.setAttribute("counters", counters);
		recordTemplate.setAttribute("it", body);

		return recordTemplate.toString();
	}

	public String getRel(final Type type,
			final String objIdentifier,
			final List<String> fields,
			final String semanticclass,
			final String semantischeme,
			final boolean inferred,
			final String trust,
			final String inferenceprovenance,
			final String provenanceaction) {
		final StringTemplate template = getTemplate(resources.getRel());

		template.setAttribute("type", type.toString());
		template.setAttribute("objIdentifier", XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(objIdentifier)));
		template.setAttribute("class", semanticclass);
		template.setAttribute("scheme", semantischeme);
		template.setAttribute("metadata", fields);
		template.setAttribute("inferred", inferred);
		template.setAttribute("trust", trust);
		template.setAttribute("inferenceprovenance", inferenceprovenance);
		template.setAttribute("provenanceaction", provenanceaction);

		return template.toString();
	}

	public String getInstance(final String resultId, final List<String> instancemetadata, final List<String> webresources) {
		final StringTemplate template = getTemplate(resources.getInstance());

		template.setAttribute("instanceId", XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(resultId)));
		template.setAttribute("metadata", instancemetadata);
		template.setAttribute("webresources", webresources);

		return template.toString();
	}

	public String getWebResource(final String identifier) {
		final StringTemplate template = getTemplate(resources.getWebresource());

		template.setAttribute("identifier", XmlRecordFactory.escapeXml(identifier));

		return template.toString();
	}

	// ////////////////////////////////////////////////////

	private StringTemplate getTemplate(final Resource res) {
		StringWriter body = new StringWriter();
		try {
			IOUtils.copy(res.getInputStream(), body);
			String string = body.toString();
			return new StringTemplate(string);
		} catch (IOException e) {
			log.error("unable to get template", e);
			throw new RuntimeException(e);
		}
	}

}
